Scriptname SuH_MCM extends SKI_ConfigBase

;	SuH_MCM : Mod Configuration Menu Script : is the script which generates and manages all MCM interactions. In conjunction with SuH_Status and SuH_Fun, this script allows the player to view status and alter the mod through custom leveling scripts or by changing settings.

;	External Scripts
SuH_Fun Property _f auto
SuH_Status Property _s auto

;	Menu Option IDs
	;	These ids are used as a universal variable for menu entries, replaced by whatever current menu we have selected. This method saves on memory usage but requires menual maintenance/tracking

	; Status displays that should be universally named
int heartxp_display
int bdsmratings_display
int skillxp_display
int status_display

int id0
int id1
int id2
int id3
int id4
int id5
int id6
int id7
int id8
int id9
int id10
int id11
int id12
int id13
int id14
int id15
int id16
int id17
int id18
int id19
int id20
int id21
int id22
int id23
int id24
int id25
int id26
int id27
int id28
int id29
int id30
int id31
int id32
int id33
int id34
int id35
int id36
int id37
int id38
int id39
int id40
int id41
int id42
int id43
int id44
int id45
int id46
int id47
int id48
int id49
;...up-to 127 minus named entries (128 array cap)

;	Script Variables
;	Whether tutorial for each menu has been seen, should reset on MCMupdate when version changes
bool seen_MCM
bool seen_status
bool seen_skill
bool seen_heart
bool seen_passives
bool seen_actives
bool seen_settings
bool seen_soul
bool seen_title
bool seen_help
;	Pet Variables, held as script variables so they can be passed through multiple functions
int[] petslotarray ; Array for Pet Slot entries
bool[] petselectarray ; Selection array for which pet slot is selected
int petmenuoption ; Action selected, such as "Summon" or "Dismiss" 0=none 1=swap
int petselectedslot ; Pet Slot currently selected, defaults to first slot unless set otherwise
int petselectedslot2 ; Second slot selection used for slot swapping
int petdeletewarning ; number of warnings before deleting a pet
;	Player referece
actor playerRef

;	OnInit
Event OnInit()
	parent.OnInit()
	InitProperties()
	MCMupdate()
endEvent

;	Init Properties
Function InitProperties()
	_f = Game.GetFormFromFile(0x814, "Succubus Heart.esp") as SuH_Fun
	_s = Game.GetFormFromFile(0x16E496, "Succubus Heart.esp") as SuH_Status
	playerRef = _s.playerRef
endFunction

;	ConfigInit (triggered by MCM itself)
Event OnConfigInit()
	ModName = "_Succubus Heart"
	Pages = new string[1]
		Pages[0] = "$SUH_Initiate"
		Pages[1] = "$SUH_Help"
endEvent

;	MCMupdate
Function MCMupdate()
	if _s.SuH_MCMversion == 0
		ModName = "_Succubus Heart"
		Pages = new string[1]
			Pages[0] = "$SUH_Initiate"
			Pages[1] = "$SUH_Help"
	elseIf _s.SuH_MCMversion < 5003008
		ModName = "_Succubus Heart"
		Pages = new string[9]
			Pages[0] = "$SUH_Status"
			Pages[1] = "$SUH_Heart Levels"
			Pages[2] = "$SUH_Skill Levels"
			Pages[3] = "$SUH_Passives"
			Pages[4] = "$SUH_Actives"
			Pages[5] = "$SUH_Soul Pets"
			Pages[6] = "$SUH_Titles"
			Pages[7] = "$SUH_Settings"
			Pages[8] = "$SUH_Help"
		_s.SuH_MCMversion = 5003008
		seen_MCM = false
		seen_status = false
		seen_skill = false
		seen_heart = false
		seen_passives = false
		seen_actives = false
		seen_settings = false
		seen_soul = false
		seen_title = false
		seen_help = false
	endIf
endFunction

;	Functions

; Passive Reset Cost Calc
int Function passiveresetcostcalc()
	int passiveresetcost = (playerref.GetLevel() * 200)
	if _s.SuH_SETfreepassivereset > 0
		passiveresetcost = 0
	endIf
	return passiveresetcost
endFunction

; Set Status Display (Passives / Actives)
Function setstatusdisplay()
	SetTextOptionValue(id0, "H:"+_s.SuH_PCScaphealth+"  M:"+_s.SuH_PCScapmagicka+"  S:"+_s.SuH_PCScapstamina)
endFunction

int function SexBonusAsMinutes()
	return Math.Ceiling( ((_s.SuH_PCSsexbonusmax * 1.0) / _s.SuH_PCSsexbonushour) * 60.0 )
endFunction

int function FluidBonusAsMinutes()
	return Math.Ceiling( ((_s.SuH_PCSfluidbonusmax * 1.0) / _s.SuH_PCSfluidbonushour) * 60.0 )
endFunction

function SetCurrencyDisplays()
	_f.PC_recalculateBDSM() ; recalculate BDSM values
	SetTextOptionValue(heartxp_display, _s.SuH_PCSxp) ; set HeartXP display
	SetTextOptionValue(bdsmratings_display, "B:"+_s.SuH_PCSbpoint+" D:"+_s.SuH_PCSdpoint+" S:"+_s.SuH_PCSspoint+" M:"+_s.SuH_PCSmpoint) ; set BDSM display
	SetTextOptionValue(skillxp_display, _s.SuH_PCSskillxp)
	SetTextOptionValue(status_display, "H:"+_s.SuH_PCScaphealth+"  M:"+_s.SuH_PCScapmagicka+"  S:"+_s.SuH_PCScapstamina)
endFunction

; Level Skill (from Skill Levels Page)
;	option = menu entry
;	skillID = internal skillID
;	skillName = display name for the skill
function SkillLevels_LevelSkill(int option, string skillID, string skillName)
	int lvl = playerRef.GetBaseActorValue(skillID) as int
	if _f.BuySkillLevel(skillID)
		if lvl < playerRef.GetBaseActorValue(skillID)
			lvl = playerRef.GetBaseActorValue(skillID) as int
			Debug.MessageBox(skillName + " level Increased to " + lvl)
		else
			Debug.MessageBox(skillName + " XP Increased")
		endIf
		SetTextOptionValue(option, Math.Floor(playerRef.GetBaseActorValue(skillID))+" ["+_f.PC_getSkillXPcost(skillID)+" SkillXP]")
		SetCurrencyDisplays()
	endif
endfunction

function SetUpPage()
	; Use state to fill in page, otherwise empty will return main page
	if seen_MCM != true && _s.SuH_MCMversion != 0
		debug.MessageBox("< Welcome to the Succubus Heart MCM! > \n When entering each page for the first time you'll see a message like this explaining the page's functions. If you ever get lost check the 'Help' MCM page for more information then check the support Discord! \n << Don't forget to visit the Settings page to configure Succubus Heart's Features! >> \n Happy Draining!")
		seen_MCM = true
	endIf
	LoadCustomContent("SuH/SuH_cover.swf")
endfunction

function AllOptionHighlightCheck(int option)
	if option == heartxp_display
		SetInfoText("$SUH_heartxp_display")
	elseif option == bdsmratings_display
		SetInfoText("$SUH_bdsmratings_display")
	elseif option == skillxp_display
		SetInfoText("$SUH_skillxp_display")
	elseif option == status_display
		SEtInfoText("$SUH_status_display")
	endif
endfunction

;	OnPageReset (Sets up the page when switching pages, use this to switch to menu state)
event OnPageReset(string page)
	if (page == "") ; Initial Page
		GoToState("")
		SetUpPage()
		return
    else
        UnloadCustomContent()
    endIf

	; reset global menu options
	heartxp_display = -1
	bdsmratings_display = -1
	skillxp_display = -1
	status_display = -1

	string switch_to_state = ""

	if page == "$SUH_Initiate" ; Initiate
		switch_to_state = "PAGE_INITIATE"
	elseif page == "$SUH_Status"
		switch_to_state = "PAGE_STATUS"
	elseif page == "$SUH_Heart Levels"
		switch_to_state = "PAGE_HEART_LEVELS"
	elseif page == "$SUH_Skill Levels"
		switch_to_state = "PAGE_SKILL_LEVELS"
	elseif page == "$SUH_Passives"
		switch_to_state = "PAGE_PASSIVES"
	elseif page == "$SUH_Actives"
		switch_to_state = "PAGE_ACTIVES"
	elseif page == "$SUH_Soul Pets"
		switch_to_state = "PAGE_SOULPETS"
	elseif page == "$SUH_Titles"
		switch_to_state = "PAGE_TITLES"
	elseif page == "$SUH_Settings"
		switch_to_state = "PAGE_SETTINGS"
	elseif page == "$SUH_Help"
		switch_to_state = "PAGE_HELP"
	endif

	if switch_to_state != ""
		GoToState(switch_to_state)
		SetUpPage()
	endif
endevent

Event OnOptionHighlight(int option)
	; Set up in page state
endEvent

Event OnOptionSelect(int option)
	; Set up in page state
endEvent

Event OnOptionMenuOpen(int option)
	; Set up in page state
endEvent

Event OnOptionMenuAccept(int option, int index)
	; Set up in page state
endEvent

Event OnOptionSliderOpen(int option)
	; Set up in page state
endEvent

Event OnOptionSliderAccept(int option, float value)
	; Set up in page state
endEvent

Event OnOptionInputOpen(int option)
	; Set up in page state
endEvent

Event OnOptionInputAccept(int option, string isnotavariablemyfuckingasspapyrusshutup)
	; Set up in page state
endEvent

; Initiate Page
state PAGE_INITIATE

	function SetUpPage()
		id0 = AddTextOption("$SUH_Start Succubus Heart", "")
	endfunction

	function OnOptionSelect(int option)
		if option == id0
			SetTextOptionValue(id0, "$SUH_INITIATE_EXITMCM")
			if _s.IsRunning() == false
				_s.Start()
			endif
			_s.InitProperties(true)
			_s.SuH_MCMversion = 5
			MCMupdate()
		endif
	endfunction

	function OnOptionHighlight(int option)
		if option == id0
			SetInfoText("$SUH_INITIATE_START_H")
		else
			AllOptionHighlightCheck(option)
		endif
	endfunction

endstate

; Status Page
state PAGE_STATUS

	function SetUpPage()
		if seen_status != 1
			debug.MessageBox("< Status > \n View key stats related to your Status, Succubus Abilities, and the mod's current state. Can also set overrides and lock various stats.")
			seen_status = 1
		endif
		
		;	Variables
		playerRef = _s.playerRef
		int effectivecap = _f.GetEffectiveCap()
		
		int healthCap = _s.SuH_PCScaphealth
		if healthcap > effectivecap
			healthCap = effectivecap
		endIf
		int magickaCap = _s.SuH_PCScapmagicka
		if magickaCap > effectivecap
			magickaCap = effectivecap
		endIf
		int staminaCap = _s.SuH_PCScapstamina
		if staminaCap > effectivecap
			staminaCap = effectivecap
		endIf
		
		bool SETdisablehealthrecovery = False
		if _s.SuH_SETdisablehealthrecovery > 0.0
			SETdisablehealthrecovery = True
		endIf
		bool SETdisablemagickarecovery = False
		if _s.SuH_SETdisablemagickarecovery > 0.0
			SETdisablemagickarecovery = True
		endIf
		bool SETdisablestaminarecovery = False
		if _s.SuH_SETdisablestaminarecovery > 0.0
			SETdisablestaminarecovery = True
		endIf
		
		if _s.SuH_framework == 1 ; SexLab
			_s.SuH_PCSgender = _s.SexLab.GetGender(playerref)
		elseif _s.SuH_framework == 2 ; OStim
			_s.PlayerRef.GetActorBase().GetSex()
		endIf
		
		string playerGender = "$SUH_FEMALE"
		if _s.SuH_PCSgender != 1 && _s.SuH_PCSgender != 3
			playerGender = "$SUH_MALE"
		endIf
		
		int sexbonusamount = 0
		if _s.SuH_PCSsexbonus > 0
			sexbonusamount = Math.Ceiling( ((_s.SuH_PCSsexbonus * 1.0) / _s.SuH_PCSsexbonushour) * 60.0 )
		endIf
		int fluidbonusamount = 0
		if _s.SuH_PCSfluidbonus > 0
			fluidbonusamount = Math.Ceiling( ((_s.SuH_PCSfluidbonus * 1.0) / _s.SuH_PCSfluidbonushour) * 60.0 )
		endIf
		
		string fworkstring = ""
		if _s.SuH_framework == 1
			fworkstring = "SexLab"
		elseif _s.SuH_framework == 2
			fworkstring = "OStim"
		endif

		SetCursorFillMode(TOP_TO_BOTTOM)

		; Left Side
		SetCursorPosition(0)

		AddHeaderOption("$SUH_Status")
		id0 = AddTextOption("$SUH_Health", (playerref.GetBaseActorValue("health") as int)+"/"+healthCap+" ("+_s.SuH_PCScaphealth+")")
		id1 = AddTextOption("$SUH_Magicka", (playerref.GetBaseActorValue("magicka") as int)+"/"+magickaCap+" ("+_s.SuH_PCScapmagicka+")")
		id2 = AddTextOption("$SUH_Stamina", (playerref.GetBaseActorValue("stamina") as int)+"/"+staminaCap+" ("+_s.SuH_PCScapstamina+")")
		id3 = AddTextOption("$SUH_Effective Cap", effectivecap)
		id4 = AddTextOption("$SUH_Sex Bonus", sexbonusamount+"min")
		id5 = AddTextOption("$SUH_Fluid Bonus", fluidbonusamount+"min")
		AddEmptyOption()
		id6 = AddTextOption("$SUH_Health Absorption Rating", _s.SuH_PCSabsorbhealth)
		id7 = AddTextOption("$SUH_Magicka Absorption Rating", _s.SuH_PCSabsorbmagicka)
		id8 = AddTextOption("$SUH_Stamina Absorption Rating", _s.SuH_PCSabsorbstamina)
		id9 = AddTextOption("$SUH_Body {"+_s.SuH_PCSbpoint+"} : Desire {"+_s.SuH_PCSdpoint+"} : Soul {"+_s.SuH_PCSspoint+"} : Mind {"+_s.SuH_PCSmpoint+"}", "")
		AddEmptyOption()
		AddHeaderOption("$SUH_Status Options")
		id10 = AddSliderOption("$SUH_Carry Weight Correction", _s.SuH_SETcarrycorrect, "{0}")
		id11 = AddToggleOption("$SUH_Disable Health Regen", SETdisablehealthrecovery)
		id12 = AddToggleOption("$SUH_Disable Magicka Regen", SETdisablemagickarecovery)
		id13 = AddToggleOption("$SUH_Disable Stamina Regen", SETdisablestaminarecovery)

		;	Right Side
		SetCursorPosition(1)

		AddHeaderOption("$SUH_Status")
		id14 = AddTextOption("$SUH_Lust Level", Math.Floor(_f.GetArousalPercent())+"%")
		id15 = AddTextOption("$SUH_Lust State", "$SUH_" + _f.GetArousalStateString(true))
		id16 = AddTextOption("$SUH_HeartXP", _s.SuH_PCSxp)
		AddEmptyOption()
		id17 = AddTextOption("$SUH_HeartXP Gain", _s.SuH_PCSxpgain+"%")
		id18 = AddTextOption("$SUH_Character Gender", playerGender)
		id19 = AddTextOption("$SUH_Character Level", playerref.GetLevel())
		AddEmptyOption()
		AddHeaderOption("$SUH_Hotkey Configuration")
		id20 = AddKeyMapOption("$SUH_Drain Affects NPC Status - Toggle", _s.SuH_KEY_draintoggle)
		id21 = AddKeyMapOption("$SUH_Allow Drain to Kill - Toggle", _s.SuH_KEY_drainkilltoggle)
		id22 = AddKeyMapOption("$SUH_View Current Lust State", _s.SuH_KEY_arousalview)
		id23 = AddKeyMapOption("$SUH_Soul Pet Summon Menu", _s.SuH_KEY_petself)
		AddEmptyOption()
		id24 = AddTextOption("$SUH_Framework Pref.", fworkstring)
		id25 = AddTextOption("$SUH_Succubus Heart Version {"+_s.SuH_MODversion+"}", "")
		AddEmptyOption()
	endfunction

	event OnOptionSliderOpen(int option)
		if option == id10
			SetSliderDialogStartValue(0)
			SetSliderDialogDefaultValue(0)
			SetSliderDialogRange(0, _f.GetMaxCarryWeightCorrection() )
			SetSliderDialogInterval(1)
		endif
	endevent

	event OnOptionSliderAccept(int option, float value)
		if option == id10
			_s.SuH_SETcarrycorrect = Math.Floor(value)
			playerref.SetActorValue("carryweight", (value + 300)) ;300 is base game carry weight, need adjust for survival mode at some point
			SetSliderOptionValue(option, value, "{0}")
		endif
	endevent

	event OnOptionKeymapChange(int option, int keyCode, string conflictControl, string conflictName)
		if option == id20
			if (keyCode == 1)
				_s.SuH_KEY_draintoggle = -1
				_f.registerforkeybind()
				SetKeyMapOptionValue(option, -1)
			else
				_s.SuH_KEY_draintoggle = KeyCode
				_f.registerforkeybind()
				SetKeyMapOptionValue(option, keyCode)
			endIf
		elseif option == id21
			if (keyCode == 1)
				_s.SuH_KEY_drainkilltoggle = -1
				_f.registerforkeybind()
				SetKeyMapOptionValue(option, -1)
			else
				_s.SuH_KEY_drainkilltoggle = KeyCode
				_f.registerforkeybind()
				SetKeyMapOptionValue(option, keyCode)
			endIf
		elseif option == id22
			if (keyCode == 1)
				_s.SuH_KEY_arousalview = -1
				_f.registerforkeybind()
				SetKeyMapOptionValue(option, -1)
			else
				_s.SuH_KEY_arousalview = KeyCode
				_f.registerforkeybind()
				SetKeyMapOptionValue(option, keyCode)
			endIf
		elseif option == id23
			if (keyCode == 1)
				_s.SuH_KEY_petself = -1
				_f.registerforkeybind()
				SetKeyMapOptionValue(option, -1)
			else
				_s.SuH_KEY_petself = KeyCode
				_f.registerforkeybind()
				SetKeyMapOptionValue(option, keyCode)
			endIf
		endif
	endevent

	event OnOptionSelect(int option)
		if option == id11
			if _s.SuH_SETdisablehealthrecovery > 0
				playerref.SetActorValue("HealRate", _s.SuH_SETdisablehealthrecovery)
				_s.SuH_SETdisablehealthrecovery = 0
				SetToggleOptionValue(option, false)
			else
				_s.SuH_SETdisablehealthrecovery = playerref.GetBaseActorValue("HealRate")
				playerref.SetActorValue("HealRate", 0.0)
				SetToggleOptionValue(option, true)
			endif
		elseif option == id12
			if _s.SuH_SETdisablemagickarecovery > 0
				playerref.SetActorValue("MagickaRate", _s.SuH_SETdisablemagickarecovery)
				_s.SuH_SETdisablemagickarecovery = 0
				SetToggleOptionValue(option, false)
			else
				_s.SuH_SETdisablemagickarecovery = playerref.GetBaseActorValue("MagickaRate")
				playerref.SetActorValue("MagickaRate", 0.0)
				SetToggleOptionValue(option, true)
			endif
		elseif option == id13
			if _s.SuH_SETdisablestaminarecovery > 0
				playerref.SetActorValue("StaminaRate", _s.SuH_SETdisablestaminarecovery)
				_s.SuH_SETdisablestaminarecovery = 0
				SetToggleOptionValue(option, false)
			else
				_s.SuH_SETdisablestaminarecovery = playerref.GetBaseActorValue("StaminaRate")
				playerref.SetActorValue("StaminaRate", 0.0)
				SetToggleOptionValue(option, true)
			endif
		elseif option == id24
			if _s.SuH_framework == 1 ; If set to SexLab
				If _s.SuH_Frame_OStim > 0
					_s.SuH_framework = 2
					_s.SuH_Frame_OStim = 2
					if _s.SuH_SETonlyframepref > 0
						if _s.SuH_Frame_SexLab  > 1
							_s.SuH_Frame_SexLab = 1
						endIf
					endIf
					SetTextOptionValue(option, "OStim")
				elseif _s.SuH_Frame_Sexlab == 0
					_s.SuH_framework = 0
					SetTextOptionValue(option, "")
				endIf
			elseif _s.SuH_framework == 2 ; If set to OStim
				if _s.SuH_Frame_Sexlab > 0
					_s.SuH_framework = 1
					_s.SuH_Frame_SexLab = 2
					if _s.SuH_SETonlyframepref > 0
						if _s.SuH_Frame_OStim  > 1
							_s.SuH_Frame_OStim = 1
						endIf
					endIf
					SetTextOptionValue(option, "SexLab")
				elseif _s.SuH_Frame_OStim == 0
					_s.SuH_framework = 0
					SetTextOptionValue(option, "")
				endIf
			else ; If no preference set
				if _s.SuH_Frame_Sexlab > 0
					_s.SuH_framework = 1
					SetTextOptionValue(option, "SexLab")
				elseif _s.SuH_Frame_OStim > 0
					_s.SuH_framework = 2
					SetTextOptionValue(option, "OStim")
				endIf
			endIf
		endif
	endevent

	function OnOptionDefault(int option)
		if option == id10
			_s.SuH_SETcarrycorrect = 300
			playerref.SetActorValue("carryweight", 300) ;300 is base game carry weight, need adjust for survival mode at some point
			SetSliderOptionValue(option, 0, "{0}")
		elseif option == id11
			if _s.SuH_SETdisablehealthrecovery > 0
				playerref.SetActorValue("HealRate", _s.SuH_SETdisablehealthrecovery)
				_s.SuH_SETdisablehealthrecovery = 0
				SetToggleOptionValue(option, false)
			endIf
		elseif option == id12
			if _s.SuH_SETdisablemagickarecovery > 0
				playerref.SetActorValue("MagickaRate", _s.SuH_SETdisablemagickarecovery)
				_s.SuH_SETdisablemagickarecovery = 0
				SetToggleOptionValue(option, false)
			endIf
		elseif option == id13
			if _s.SuH_SETdisablestaminarecovery > 0
				playerref.SetActorValue("StaminaRate", _s.SuH_SETdisablestaminarecovery)
				_s.SuH_SETdisablestaminarecovery = 0
				SetToggleOptionValue(option, false)
			endIf
		elseif option == id20
			_s.SuH_KEY_draintoggle = -1
			_f.registerforkeybind()
			SetKeyMapOptionValue(option, -1)
		elseif option == id21
			_s.SuH_KEY_drainkilltoggle = -1
			_f.registerforkeybind()
			SetKeyMapOptionValue(option, -1)
		elseif option == id22
			_s.SuH_KEY_arousalview = -1
			_f.registerforkeybind()
			SetKeyMapOptionValue(option, -1)
		elseif option == id23
			_s.SuH_KEY_petself = -1
			_f.registerforkeybind()
			SetKeyMapOptionValue(option, -1)
		endif
	endfunction

	function OnOptionHighlight(int option)
		if option == id0
			SetInfoText("$SUH_STATUS_HEALTHCAP")
		elseif option == id1
			SetInfoText("$SUH_STATUS_MAGICKACAP")
		elseif option == id2
			SetInfoText("$SUH_STATUS_STAMINACAP")
		elseif option == id3
			SetInfoText("$SUH_STATUS_EFFECTIVECAP")
		elseif option == id4
			SetInfoText("$SUH_STATUS_SEXBONUS")
		elseif option == id5
			SetInfoText("$SUH_STATUS_FLUIDBONUS")
		elseif option == id6
			SetInfoText("$SUH_STATUS_HEALTHABSORB")
		elseif option == id7
			SetInfoText("$SUH_STATUS_MAGICKAABSORB")
		elseif option == id8
			SetInfoText("$SUH_STATUS_STAMINAABSORB")
		elseif option == id9
			SetInfoText("$SUH_STATUS_BDSMPOINTS")
		elseif option == id10
			SetInfoText("$SUH_STATUS_CARRYWEIGHTCORRECTION")
		elseif option == id11
			SetInfoText("$SUH_STATUS_DISABLEHEALTHREGEN")
		elseif option == id12
			SetInfoText("$SUH_STATUS_DISABLEMAGICKAREGEN")
		elseif option == id13
			SetInfoText("$SUH_STATUS_DISABLESTAMINAREGEN")
		elseif option == id14
			SetInfoText("$SUH_STATUS_LUSTLEVEL")
		elseif option == id15
			int x = _s.SuH_PCSarousalstate
			if x == 0
				SetInfoText("$SUH_STATUS_LUSTSTATE_0")
			elseif x == 1
				SetInfoText("$SUH_STATUS_LUSTSTATE_1")
			elseif x == 2
				SetInfoText("$SUH_STATUS_LUSTSTATE_2")
			elseif x == 3
				SetInfoText("$SUH_STATUS_LUSTSTATE_3")
			elseif x == 4
				SetInfoText("$SUH_STATUS_LUSTSTATE_4")
			endIf
		elseif option == id16
			SetInfoText("$SUH_STATUS_HEARTXP")
		elseif option == id17
			SetInfoText("$SUH_STATUS_HEARTXPGAIN")
		elseif option == id18
			SetInfoText("$SUH_STATUS_CHARACTERGENDER")
		elseif option == id19
			SetInfoText("$SUH_STATUS_CHARACTERLEVEL")
		elseif option == id20
			SetInfoText("$SUH_STATUS_DRAINAFFECTNPC_KEYBIND")
		elseif option == id21
			SetInfoText("$SUH_STATUS_DRAINKILL_KEYBIND")
		elseif option == id22
			SetInfoText("$SUH_STATUS_CURRENTLUSTSTATE_KEYBIND")
		elseif option == id23
			SetInfoText("$SUH_STATUS_SOULPETMENU_KEYBIND")
		elseif option == id24
			SetInfoText("$SUH_STATUS_FRAMEWORKPREF")
		elseif option == id25
			SetInfoText("$SUH_STATUS_SUHVERSION")
		else
			AllOptionHighlightCheck(option)
		endif
	endfunction

endstate

; Heart Levels Page
state PAGE_HEART_LEVELS

	function SetUpPage()
		if seen_heart != true
			debug.MessageBox("< Heart Levels > \n Use HeartXP to enhance your native Succubus Stats. Earn HeartXP through Succubus Heart activities such as draining enemies or satisfying your desires.")
			seen_heart = true
		endIf
		SetCursorFillMode(TOP_TO_BOTTOM) ; id18 +
		
		;	Left Side
		SetCursorPosition(0)
		heartxp_display = AddTextOption("$SUH_HeartXP available", _s.SuH_PCSxp)
		AddHeaderOption("$SUH_Heart Levels")
		id0 = AddTextOption("$SUH_+1 Health Cap", _s.SuH_PCScaphealth+" ["+_f.PC_getHeartXPcost("capHealth")+" XP]")
		id1 = AddTextOption("$SUH_+1 Magicka Cap", _s.SuH_PCScapmagicka+" ["+_f.PC_getHeartXPcost("capMagicka")+" XP]")
		id2 = AddTextOption("$SUH_+1 Stamina Cap", _s.SuH_PCScapstamina+" ["+_f.PC_getHeartXPcost("capStamina")+" XP]")
		id3 = AddTextOption("$SUH_+1 Effective Cap", (_s.SuH_PCScaplevel + 6)+" ("+_f.GetEffectiveCap()+") ["+_f.PC_getHeartXPcost("capEffect")+" XP]")
		AddEmptyOption()
		id4 = AddTextOption("$SUH_+10% Max Sex Bonus", SexBonusAsMinutes()+"min ["+_f.PC_getHeartXPcost("sexBonus")+" XP]")
		id5 = AddTextOption("$SUH_+10% Max Fluid Bonus", FluidBonusAsMinutes()+"min ["+_f.PC_getHeartXPcost("fluidBonus")+" XP]")
		AddEmptyOption()
		id6 = AddTextOption("$SUH_HeartXP Gain", _s.SuH_PCSxpgain+"% ["+_f.PC_getHeartXPcost("xpGain")+" XP]")

		; Right Side
		SetCursorPosition(1)
		bdsmratings_display = AddTextOption("$SUH_BDSM Ratings", "B:"+_s.SuH_PCSbpoint+" D:"+_s.SuH_PCSdpoint+" S:"+_s.SuH_PCSspoint+" M:"+_s.SuH_PCSmpoint)
		AddHeaderOption("$SUH_Heart Levels")
		id7 = AddTextOption("$SUH_+1 Health Absorption Rating", _s.SuH_PCSabsorbhealth+" ["+_f.PC_getHeartXPcost("absorbHealth")+" XP]")
		id8 = AddTextOption("$SUH_+1 Magicka Absorption Rating", _s.SuH_PCSabsorbmagicka+" ["+_f.PC_getHeartXPcost("absorbMagicka")+" XP]")
		id9 = AddTextOption("$SUH_+1 Stamina Absorption Rating", _s.SuH_PCSabsorbstamina+" ["+_f.PC_getHeartXPcost("absorbStamina")+" XP]")
		AddEmptyOption()
		id10 = AddTextOption("$SUH_+1 Fluid Health Bonus", _s.SuH_PCSfluidhealth+" ["+_f.PC_getHeartXPcost("fluidHealth")+" XP]")
		id11 = AddTextOption("$SUH_+1 Fluid Magicka Bonus", _s.SuH_PCSfluidmagicka+" ["+_f.PC_getHeartXPcost("fluidMagicka")+" XP]")
		id12 = AddTextOption("$SUH_+1 Fluid Stamina Bonus", _s.SuH_PCSfluidstamina+" ["+_f.PC_getHeartXPcost("fluidStamina")+" XP]")
		AddEmptyOption()
		AddEmptyOption()
	endfunction

	event OnOptionSelect(int option)
		if option == id0
			if _f.BuyHeartLevel("capHealth")
				SetTextOptionValue(option, _s.SuH_PCScaphealth+" ["+_f.PC_getHeartXPcost("capHealth")+" XP]")
			endif
		elseif option == id1
			if _f.BuyHeartLevel("capMagicka")
				SetTextOptionValue(option, _s.SuH_PCScapmagicka+" ["+_f.PC_getHeartXPcost("capMagicka")+" XP]")
			endif
		elseif option == id2
			if _f.BuyHeartLevel("capStamina")
				SetTextOptionValue(option, _s.SuH_PCScapstamina+" ["+_f.PC_getHeartXPcost("capStamina")+" XP]")
			endif
		elseif option == id3
			if _f.BuyHeartLevel("capEffect")
				SetTextOptionValue(option, (_s.SuH_PCScaplevel + 6)+" ("+_f.GetEffectiveCap()+") ["+_f.PC_getHeartXPcost("capEffect")+" XP]")
			endif
		elseif option == id4
			if _f.BuyHeartLevel("sexBonus")
				SetTextOptionValue(option, SexBonusAsMinutes()+"min ["+_f.PC_getHeartXPcost("sexBonus")+" XP]")
			endif
		elseif option == id5
			if _f.BuyHeartLevel("fluidBonus")
				SetTextOptionValue(option, FluidBonusAsMinutes()+"min ["+_f.PC_getHeartXPcost("fluidBonus")+" XP]")
			endif
		elseif option == id6
			if _f.BuyHeartLevel("xpGain")
				SetTextOptionValue(option, _s.SuH_PCSxpgain+"% ["+_f.PC_getHeartXPcost("xpGain")+" XP]")
			endif
		elseif option == id7
			if _f.BuyHeartLevel("absorbHealth")
				SetTextOptionValue(option, _s.SuH_PCSabsorbhealth+" ["+_f.PC_getHeartXPcost("absorbHealth")+" XP]")
			endif
		elseif option == id8
			if _f.BuyHeartLevel("absorbMagicka")
				SetTextOptionValue(option, _s.SuH_PCSabsorbmagicka+" ["+_f.PC_getHeartXPcost("absorbMagicka")+" XP]")
			endif
		elseif option == id9
			if _f.BuyHeartLevel("absorbStamina")
				SetTextOptionValue(option, _s.SuH_PCSabsorbstamina+" ["+_f.PC_getHeartXPcost("absorbStamina")+" XP]")
			endif
		elseif option == id10
			if _f.BuyHeartLevel("fluidHealth")
				SetTextOptionValue(option, _s.SuH_PCSfluidhealth+" ["+_f.PC_getHeartXPcost("fluidHealth")+" XP]")
			endif
		elseif option == id11
			if _f.BuyHeartLevel("fluidMagicka")
				SetTextOptionValue(option, _s.SuH_PCSfluidmagicka+" ["+_f.PC_getHeartXPcost("fluidMagicka")+" XP]")
			endif
		elseif option == id12
			if _f.BuyHeartLevel("fluidStamina")
				SetTextOptionValue(option, _s.SuH_PCSfluidstamina+" ["+_f.PC_getHeartXPcost("fluidStamina")+" XP]")
			endif
		endif
		SetCurrencyDisplays()
	endevent

	event OnOptionHighlight(int option)
		if option == id0
			SetInfoText("$SUH_HLEVELS_HEALTHCAPUP")
		elseif option == id1
			SetInfoText("$SUH_HLEVELS_MAGICKACAPUP")
		elseif option == id2
			SetInfoText("$SUH_HLEVELS_STAMINACAPUP")
		elseif option == id3
			SetInfoText("$SUH_HLEVELS_EFFECTIVECAPUP")
		elseif option == id4
			SetInfoText("$SUH_HLEVELS_MAXSEXBONUS")
		elseif option == id5
			SetInfoText("$SUH_HLEVELS_MAXFLUIDBONUS")
		elseif option == id6
			SetInfoText("$SUH_HLEVELS_HEARTXPGAIN")
		elseif option == id7
			SetInfoText("$SUH_HLEVELS_HEALTHABSORB")
		elseif option == id8
			SetInfoText("$SUH_HLEVELS_MAGICKAABSORB")
		elseif option == id9
			SetInfoText("$SUH_HLEVELS_STAMINAABSORB")
		elseif option == id10
			SetInfoText("$SUH_HLEVELS_FLUIDHEALTH")
		elseif option == id11
			SetInfoText("$SUH_HLEVELS_FLUIDMAGICKA")
		elseif option == id12
			SetInfoText("$SUH_HLEVELS_FLUIDSTAMINA")
		else
			AllOptionHighlightCheck(option)
		endif
	endevent

endstate

; Skill Levels Page
state PAGE_SKILL_LEVELS

	function SetUpPage()
		if seen_skill != true
			debug.MessageBox("< Skill Levels > \n Spend SkillXP you've earned through Succubus Heart to level up vanilla skills. Earn SkillXP through Succubus Heart activities, such as draining beyond your Status Cap or letting your Status decay.")
			seen_skill = true
		endIf
		
		SetCursorFillMode(TOP_TO_BOTTOM) ; id1
		;	Left Side
		SetCursorPosition(0)
		skillxp_display = AddTextOption("SkillXP", _s.SuH_PCSskillxp)
		AddEmptyOption()
		AddHeaderOption("$SUH_Level Skills")
		id1 = AddTextOption("$SUH_Alchemy", Math.Floor(playerRef.GetBaseActorValue("alchemy"))+" ["+_f.PC_getSkillXPcost("alchemy")+" SkillXP]")
		id3 = AddTextOption("$SUH_Block", Math.Floor(playerRef.GetBaseActorValue("block"))+" ["+_f.PC_getSkillXPcost("block")+" SkillXP]")
		id5 = AddTextOption("$SUH_Destruction", Math.Floor(playerRef.GetBaseActorValue("destruction"))+" ["+_f.PC_getSkillXPcost("destruction")+" SkillXP]")
		id7 = AddTextOption("$SUH_Heavy Armor", Math.Floor(playerRef.GetBaseActorValue("heavyarmor"))+" ["+_f.PC_getSkillXPcost("heavyarmor")+" SkillXP]")
		id9 = AddTextOption("$SUH_Light Armor", Math.Floor(playerRef.GetBaseActorValue("lightarmor"))+" ["+_f.PC_getSkillXPcost("lightarmor")+" SkillXP]")
		id11 = AddTextOption("$SUH_Marksman", Math.Floor(playerRef.GetBaseActorValue("marksman"))+" ["+_f.PC_getSkillXPcost("marksman")+" SkillXP]")
		id13 = AddTextOption("$SUH_Pickpocket", Math.Floor(playerRef.GetBaseActorValue("pickpocket"))+" ["+_f.PC_getSkillXPcost("pickpocket")+" SkillXP]")
		id15 = AddTextOption("$SUH_Smithing", Math.Floor(playerRef.GetBaseActorValue("smithing"))+" ["+_f.PC_getSkillXPcost("smithing")+" SkillXP]")
		id17 = AddTextOption("$SUH_Speechcraft", Math.Floor(playerRef.GetBaseActorValue("speechcraft"))+" ["+_f.PC_getSkillXPcost("speechcraft")+" SkillXP]")
		;	Right Side
		SetCursorPosition(1)
		heartxp_display = AddTextOption("$SUH_XP available", _s.SuH_PCSxp) ;skill.xp
		id0 = AddSliderOption("$SUH_XP to SPXP {"+"(10->1)"+"}",0,"{0}") ;skill.convert
		AddHeaderOption("$SUH_Level Skills")
		id2 = AddTextOption("$SUH_Alteration", Math.Floor(playerRef.GetBaseActorValue("alteration"))+" ["+_f.PC_getSkillXPcost("alteration")+" SkillXP]")
		id4 = AddTextOption("$SUH_Conjuration", Math.Floor(playerRef.GetBaseActorValue("conjuration"))+" ["+_f.PC_getSkillXPcost("conjuration")+" SkillXP]")
		id6 = AddTextOption("$SUH_Enchanting", Math.Floor(playerRef.GetBaseActorValue("enchanting"))+" ["+_f.PC_getSkillXPcost("enchanting")+" SkillXP]")
		id8 = AddTextOption("$SUH_Illusion", Math.Floor(playerRef.GetBaseActorValue("illusion"))+" ["+_f.PC_getSkillXPcost("illusion")+" SkillXP]")
		id10 = AddTextOption("$SUH_Lockpicking", Math.Floor(playerRef.GetBaseActorValue("lockpicking"))+" ["+_f.PC_getSkillXPcost("lockpicking")+" SkillXP]")
		id12 = AddTextOption("$SUH_One-Handed", Math.Floor(playerRef.GetBaseActorValue("onehanded"))+" ["+_f.PC_getSkillXPcost("onehanded")+" SkillXP]")
		id14 = AddTextOption("$SUH_Restoration", Math.Floor(playerRef.GetBaseActorValue("restoration"))+" ["+_f.PC_getSkillXPcost("restoration")+" SkillXP]")
		id16 = AddTextOption("$SUH_Sneak", Math.Floor(playerRef.GetBaseActorValue("sneak"))+" ["+_f.PC_getSkillXPcost("sneak")+" SkillXP]")
		id18 = AddTextOption("$SUH_Two-Handed", Math.Floor(playerRef.GetBaseActorValue("twohanded"))+" ["+_f.PC_getSkillXPcost("twohanded")+" SkillXP]")
	endfunction

	event OnOptionSliderOpen(int option)
		if option == id0
			SetSliderDialogStartValue(0)
			SetSliderDialogDefaultValue(0)
			SetSliderDialogRange(0, (Math.Floor(_s.SuH_PCSxp * 0.1) * 10) )
			SetSliderDialogInterval(10)
		endif
	endevent

	event OnOptionSliderAccept(int option, float value)
		_s.SuH_PCSxp -= Math.Floor(value)
		_s.SuH_PCSskillxp += Math.Floor(value/10)
		debug.MessageBox("Converted "+(Math.Floor(value))+"HeartXP into "+(Math.Floor((value/10)))+"SkillXP")
		SetCurrencyDisplays()
	endevent

	event OnOptionSelect(int option)
		if option == id1
			SkillLevels_LevelSkill(option, "alchemy", "Alchemy")
		elseif option == id2
			SkillLevels_LevelSkill(option, "alteration", "Alteration")
		elseif option == id3
			SkillLevels_LevelSkill(option, "block", "Block")
		elseif option == id4
			SkillLevels_LevelSkill(option, "conjuration", "Conjuration")
		elseif option == id5
			SkillLevels_LevelSkill(option, "destruction", "Destruction")
		elseif option == id6
			SkillLevels_LevelSkill(option, "enchanting", "Enchanting")
		elseif option == id7
			SkillLevels_LevelSkill(option, "heavyarmor", "Heavy Armor")
		elseif option == id8
			SkillLevels_LevelSkill(option, "illusion", "Illusion")
		elseif option == id9
			SkillLevels_LevelSkill(option, "lightarmor", "Light Armor")
		elseif option == id10
			SkillLevels_LevelSkill(option, "lockpicking", "Lockpicking")
		elseif option == id11
			SkillLevels_LevelSkill(option, "marksman", "Marksman")
		elseif option == id12
			SkillLevels_LevelSkill(option, "onehanded", "One-Handed")
		elseif option == id13
			SkillLevels_LevelSkill(option, "pickpocket", "Pickpocket")
		elseif option == id14
			SkillLevels_LevelSkill(option, "restoration", "Restoration")
		elseif option == id15
			SkillLevels_LevelSkill(option, "smithing", "Smithing")
		elseif option == id16
			SkillLevels_LevelSkill(option, "sneak", "Sneak")
		elseif option == id17
			SkillLevels_LevelSkill(option, "speechcraft", "Speechcraft")
		elseif option == id18
			SkillLevels_LevelSkill(option, "twohanded", "Two-Handed")
		endif
	endevent

	event OnOptionHighlight(int option)
		if option == id0
			SetInfoText("$SUH_SLEVELS_CONVERT")
		elseif option == id1
			SetInfoText("$SUH_SLEVELS_ALCHEMY")
		elseif option == id2
			SetInfoText("$SUH_SLEVELS_ALTERATION")
		elseif option == id3
			SetInfoText("$SUH_SLEVELS_BLOCK")
		elseif option == id4
			SetInfoText("$SUH_SLEVELS_CONJURATION")
		elseif option == id5
			SetInfoText("$SUH_SLEVELS_DESTRUCTION")
		elseif option == id6
			SetInfoText("$SUH_SLEVELS_ENCHANTING")
		elseif option == id7
			SetInfoText("$SUH_SLEVELS_HEAVYARMOR")
		elseif option == id8
			SetInfoText("$SUH_SLEVELS_ILLUSION")
		elseif option == id9
			SetInfoText("$SUH_SLEVELS_LIGHTARMOR")
		elseif option == id10
			SetInfoText("$SUH_SLEVELS_LOCKPICKING")
		elseif option == id11
			SetInfoText("$SUH_SLEVELS_MARKSMAN")
		elseif option == id12
			SetInfoText("$SUH_SLEVELS_ONEHANDED")
		elseif option == id13
			SetInfoText("$SUH_SLEVELS_PICKPOCKET")
		elseif option == id14
			SetInfoText("$SUH_SLEVELS_RESTORATION")
		elseif option == id15
			SetInfoText("$SUH_SLEVELS_SMITHING")
		elseif option == id16
			SetInfoText("$SUH_SLEVELS_SNEAK")
		elseif option == id17
			SetInfoText("$SUH_SLEVELS_SPEECHCRAFT")
		elseif option == id18
			SetInfoText("$SUH_SLEVELS_TWOHANDED")
		else
			AllOptionHighlightCheck(option)
		endif
	endevent

endstate

; Passives Page
state PAGE_PASSIVES

	function SetUpPage()
		if seen_passives != true
			debug.MessageBox("< Passives > \n Spend/Decrease Status Caps to unlock or strengthen your Passive Succubus Abilities. Passive Abilities gain additional bonuses based on your BDSM Rating. BDSM Rating is improved when increasing Heart Levels.")
			seen_passives = true
		endIf
		
		;ent/ Variables
		string selfstackerplus = "Locked"
		if _s.SuH_rank_selfstackerplus > 0
			selfstackerplus = "Unlocked"
		endIf
		string giftedconsentplus = "Locked"
		if _s.SuH_rank_giftedconsentplus > 0
			giftedconsentplus = "Unlocked"
		endIf
		string capexcelplus = "Locked"
		if _s.SuH_rank_capexcelplus > 0
			capexcelplus = "Unlocked"
		endIf
		string soultapplus = "Locked"
		if _s.SuH_rank_soultapplus > 0
			soultapplus = "Unlocked"
		endIf
		
		SetCursorFillMode(TOP_TO_BOTTOM); id46+
		
		;	Left Side
		SetCursorPosition(0)
		status_display = AddTextOption("$SUH_Status", "H:"+_s.SuH_PCScaphealth+"  M:"+_s.SuH_PCScapmagicka+"  S:"+_s.SuH_PCScapstamina)
		bdsmratings_display = AddTextOption("$SUH_BDSM Ratings", "B:"+_s.SuH_PCSbpoint+" D:"+_s.SuH_PCSdpoint+" S:"+_s.SuH_PCSspoint+" M:"+_s.SuH_PCSmpoint)

		AddHeaderOption("$SUH_Combat Passives")

		id0 = AddTextOption("$SUH_Masochist", "$SUH_rank {"+(_s.SuH_rank_masochist + _s.SuH_rank_masochist2 + _s.SuH_rank_masochist3)+"}")
		id1 = AddTextOption("$SUH_+ Lust Gained", _s.SuH_rank_masochist)
		id2 = AddTextOption("$SUH_+ Stamina Recovery", _s.SuH_rank_masochist2)
		id3 = AddTextOption("$SUH_+ HeartXP Earned", _s.SuH_rank_masochist3)

		id4 = AddTextOption("$SUH_Violence", "$SUH_rank {"+(_s.SuH_rank_violence + _s.SuH_rank_violence2 + _s.SuH_rank_violence3)+"}")
		id5 = AddTextOption("$SUH_+ Health Absorbtion", _s.SuH_rank_violence)
		id6 = AddTextOption("$SUH_+ Magicka Absorption", _s.SuH_rank_violence2)
		id7 = AddTextOption("$SUH_+ Stamina Absorption", _s.SuH_rank_violence3)

		id8 = AddTextOption("$SUH_Regal Glow", "$SUH_rank {"+_s.SuH_rank_regalglow+"}")
		id9 = AddTextOption("$SUH_+ Armor Rating", _s.SuH_rank_regalglow)

		id10 = AddTextOption("$SUH_Saving Essence", "$SUH_rank {"+(_s.SuH_rank_savingessence + _s.SuH_rank_savingessence2)+"}")
		id11 = AddTextOption("$SUH_+ Health Recovery", _s.SuH_rank_savingessence)
		id12 = AddTextOption("$SUH_- Fluid Bonus Cost", _s.SuH_rank_savingessence2)

		AddHeaderOption("$SUH_Sex Passives")

		id13 = AddTextOption("$SUH_Seducer", "$SUH_rank {"+(_s.SuH_rank_seducer + _s.SuH_rank_seducer2)+"}")
		id14 = AddTextOption("$SUH_+ Success Rate", _s.SuH_rank_seducer)
		id15 = AddTextOption("$SUH_+ Lust Resistance", _s.SuH_rank_seducer2)

		id16 = AddTextOption("$SUH_Devious Partner", "$SUH_rank {"+(_s.SuH_rank_deviouspartner + _s.SuH_rank_deviouspartner2)+"}")
		id17 = AddTextOption("$SUH_+ Steal Gold Chance", _s.SuH_rank_deviouspartner)
		id18 = AddTextOption("$SUH_+ Steal Item Chance", _s.SuH_rank_deviouspartner2)

		id19 = AddTextOption("$SUH_Gifted Consent", "$SUH_rank {"+_s.SuH_rank_giftedconsent+"}")
		id20 = AddTextOption("$SUH_+ Max Status Increase", _s.SuH_rank_giftedconsent)
		id21 = AddTextOption("$SUH_= Gifted Consent+", giftedconsentplus)
		;	Right Side
		SetCursorPosition(1)
		id22 = AddTextOption("$SUH_Increase Rating", _f.PC_getHeartXPcost("BDSMrank")+" XP")
		id23 = AddTextOption("$SUH_>>> Reset Passives/Actives", passiveresetcostcalc()+" XP")

		AddHeaderOption("$SUH_Supportive Passives")

		id24 = AddTextOption("$SUH_Luscious Liquids", "$SUH_rank {"+(_s.SuH_rank_lusciousliquids + _s.SuH_rank_lusciousliquids2)+"}")
		id25 = AddTextOption("$SUH_+ Status Recovery", _s.SuH_rank_lusciousliquids)
		id26 = AddTextOption("$SUH_+ Fluid Bonus Gain", _s.SuH_rank_lusciousliquids2)

		id27 = AddTextOption("$SUH_Cap Excel", "$SUH_rank {"+(_s.SuH_rank_capexcel + _s.SuH_rank_capexcel2)+"}")
		id28 = AddTextOption("$SUH_+ Potential Cap", _s.SuH_rank_capexcel)
		id29 = AddTextOption("$SUH_+ Decay Delay", _s.SuH_rank_capexcel2)
		id30 = AddTextOption("$SUH_= Cap Excel+", capexcelplus)

		id31 = AddTextOption("$SUH_Formal Beauty", "$SUH_rank {"+_s.SuH_rank_formalbeauty+"}")
		id32 = AddTextOption("$SUH_+ Status Recovery", _s.SuH_rank_formalbeauty)

		id33 = AddTextOption("$SUH_Self Indulgent", "$SUH_rank {"+_s.SuH_rank_selfstacker+"}")
		id34 = AddTextOption("$SUH_+ Sex Bonus Gain", _s.SuH_rank_selfstacker)
		id35 = AddTextOption("$SUH_= Self Indulgent+", selfstackerplus)
		AddEmptyOption()
		AddHeaderOption("$SUH_Sex Passives")

		id36 = AddTextOption("$SUH_Healthy Absorber", "$SUH_rank {"+_s.SuH_rank_healthyabsorber+"}")
		id37 = AddTextOption("$SUH_+ Healing/Recovery", _s.SuH_rank_healthyabsorber)

		id38 = AddTextOption("$SUH_Soul Siphon", "$SUH_rank {"+_s.SuH_rank_soultap+"}")
		id39 = AddTextOption("$SUH_+ Soul Trap Chance", _s.SuH_rank_soultap)
		id40 = AddTextOption("$SUH_= Soul Siphon+", soultapplus)

		id41 = AddTextOption("$SUH_Perfect Orgasm", "$SUH_rank {"+(_s.SuH_rank_perfectorgasm + _s.SuH_rank_perfectorgasm2)+"}")
		id42 = AddTextOption("$SUH_+ Rare Drop Chance", _s.SuH_rank_perfectorgasm)
		id43 = AddTextOption("$SUH_+ Death Drop Chance", _s.SuH_rank_perfectorgasm2)
		AddEmptyOption()
	endfunction

	event OnOptionSelect(int option)
		if option == id1
			if _f.SpendStatusCap(15, 0, 0, true)
				_s.SuH_rank_masochist += 1
				SetTextOptionValue(option, _s.SuH_rank_masochist)
				SetTextOptionValue(id0, "$SUH_rank {"+(_s.SuH_rank_masochist + _s.SuH_rank_masochist2 + _s.SuH_rank_masochist3)+"}")
			endif
		elseif option == id2
			if _f.SpendStatusCap(15, 0, 0, true)
				_s.SuH_rank_masochist2 += 1
				SetTextOptionValue(option, _s.SuH_rank_masochist2)
				SetTextOptionValue(id0, "$SUH_rank {"+(_s.SuH_rank_masochist + _s.SuH_rank_masochist2 + _s.SuH_rank_masochist3)+"}")
			endIf
		elseif option == id3
			if _f.SpendStatusCap(0, 0, 30, true)
				_s.SuH_rank_masochist3 += 1
				SetTextOptionValue(option, _s.SuH_rank_masochist3)
				SetTextOptionValue(id0, "$SUH_rank {"+(_s.SuH_rank_masochist + _s.SuH_rank_masochist2 + _s.SuH_rank_masochist3)+"}")
			endIf
		elseif option == id5
			if _s.SuH_rank_violence >= 1
				debug.MessageBox("Violence has reached the max rank available on this path!")
			elseIf _f.SpendStatusCap(80, 0, 0, true)
				_s.SuH_rank_violence += 1
				SetTextOptionValue(option, _s.SuH_rank_violence)
				SetTextOptionValue(id4, "$SUH_rank {"+(_s.SuH_rank_violence + _s.SuH_rank_violence2 + _s.SuH_rank_violence3)+"}")
			endIf
		elseif option == id6
			if _s.SuH_rank_violence2 >= 1
				debug.MessageBox("Violence has reached the max rank available on this path!")
			elseIf _f.SpendStatusCap(0, 80, 0, true)
				_s.SuH_rank_violence2 += 1
				SetTextOptionValue(option, _s.SuH_rank_violence2)
				SetTextOptionValue(id4, "$SUH_rank {"+(_s.SuH_rank_violence + _s.SuH_rank_violence2 + _s.SuH_rank_violence3)+"}")
			endIf
		elseif option == id7
			if _s.SuH_rank_violence3 >= 1
				debug.MessageBox("Violence has reached the max rank available on this path!")
			elseIf _f.SpendStatusCap(0, 0, 80, true)
				_s.SuH_rank_violence3 += 1
				SetTextOptionValue(option, _s.SuH_rank_violence3)
				SetTextOptionValue(id4, "$SUH_rank {"+(_s.SuH_rank_violence + _s.SuH_rank_violence2 + _s.SuH_rank_violence3)+"}")
			endIf
		elseif option == id9
			if _s.SuH_rank_regalglow >= 5
				debug.MessageBox("Regal Glow has reached the max rank available on this path!")
			elseIf _f.SpendStatusCap(0, 25, 0, true)
				_s.SuH_rank_regalglow += 1
				SetTextOptionValue(option, _s.SuH_rank_regalglow)
				SetTextOptionValue(id8, "$SUH_rank {"+_s.SuH_rank_regalglow+"}")
			endIf
		elseif option == id11
			if _f.SpendStatusCap(30, 0, 0, true)
				_s.SuH_rank_savingessence += 1
				SetTextOptionValue(option, _s.SuH_rank_savingessence)
				SetTextOptionValue(id10, "$SUH_rank {"+(_s.SuH_rank_savingessence + _s.SuH_rank_savingessence2)+"}")
			endIf
		elseif option == id12
			if _s.SuH_rank_savingessence2 > 13
				debug.MessageBox("Saving Essence has reached the max rank available on this path!")
			elseif _f.SpendStatusCap(0, 30, 0, true)
				_s.SuH_rank_savingessence2 += 1
				SetTextOptionValue(option, _s.SuH_rank_savingessence2)
				SetTextOptionValue(id10, "$SUH_rank {"+(_s.SuH_rank_savingessence + _s.SuH_rank_savingessence2)+"}")
			endIf
		elseif option == id14
			if _s.SuH_rank_seducer >= 5
				debug.MessageBox("Seducer has reached the max rank available on this path!")
			elseif _f.SpendStatusCap(30, 30, 30, true)
				_s.SuH_rank_seducer += 1
				SetTextOptionValue(option, _s.SuH_rank_seducer)
				SetTextOptionValue(id13, "$SUH_rank {"+(_s.SuH_rank_seducer + _s.SuH_rank_seducer2)+"}")
			endIf
		elseif option == id15
			if _f.SpendStatusCap(0, 0, 35, true)
				_s.SuH_rank_seducer2 += 1
				SetTextOptionValue(option, _s.SuH_rank_seducer2)
				SetTextOptionValue(id13, "$SUH_rank {"+(_s.SuH_rank_seducer + _s.SuH_rank_seducer2)+"}")
			endIf
		elseif option == id17
			if _s.SuH_rank_deviouspartner >= 5
				debug.MessageBox("Devious Partner has reached the max rank available on this path!")
			elseif _f.SpendStatusCap(0, 0, 20, true)
				_s.SuH_rank_deviouspartner += 1
				SetTextOptionValue(option, _s.SuH_rank_deviouspartner)
				SetTextOptionValue(id16, "$SUH_rank {"+(_s.SuH_rank_deviouspartner + _s.SuH_rank_deviouspartner2)+"}")
			endIf
		elseif option == id18
			if _s.SuH_rank_deviouspartner2 >= 10
				debug.MessageBox("Devious Partner has reached the max rank available on this path!")
			elseIf _f.SpendStatusCap(0, 30, 0, true)
				_s.SuH_rank_deviouspartner2 += 1
				SetTextOptionValue(option, _s.SuH_rank_deviouspartner2)
				SetTextOptionValue(id16, "$SUH_rank {"+(_s.SuH_rank_deviouspartner + _s.SuH_rank_deviouspartner2)+"}")
			endif
		elseif option == id20
			if _f.SpendStatusCap(0, 10, 5, true)
				_s.SuH_rank_giftedconsent += 1
				SetTextOptionValue(option, _s.SuH_rank_giftedconsent)
				SetTextOptionValue(id19, "$SUH_rank {"+_s.SuH_rank_giftedconsent+"}")
			endIf
		elseif option == id21
			if _s.SuH_rank_giftedconsentplus > 0
				debug.MessageBox("Gifted Consent+ Already Unlocked")
			elseif _f.SpendStatusCap(40, 40, 40, true)
				_s.SuH_rank_giftedconsentplus += 1
				SetTextOptionValue(option, "Unlocked")
				SetCurrencyDisplays()
			endIf
		elseif option == id22
			if _f.SpendHeartXP(_f.PC_getHeartXPcost("BDSMrank"), true)
				_s.SuH_rank_bdsm += 1
				_f.PC_recalculateBDSM()
				debug.MessageBox("BodyDesireSoulMind Rating has been increased!")
				SetTextOptionValue(option, _f.PC_getHeartXPcost("BDSMrank")+" XP")
			endIf
		elseif option == id23
			_f.PassiveReset()
			ForcePageReset()
		elseif option == id25
			if _f.SpendStatusCap(20, 0, 0, true)
				_s.SuH_rank_lusciousliquids += 1
				SetTextOptionValue(option, _s.SuH_rank_lusciousliquids)
				SetTextOptionValue(id24, "$SUH_rank {"+(_s.SuH_rank_lusciousliquids + _s.SuH_rank_lusciousliquids2)+"}")
			endIf
		elseif option == id26
			if _f.SpendStatusCap(0, 0, 10, true)
				_s.SuH_rank_lusciousliquids2 += 1
				SetTextOptionValue(option, _s.SuH_rank_lusciousliquids2)
				SetTextOptionValue(id24, "$SUH_rank {"+(_s.SuH_rank_lusciousliquids + _s.SuH_rank_lusciousliquids2)+"}")
			endIf
		elseif option == id28
			if _f.SpendStatusCap(15, 15, 15, true)
				_s.SuH_rank_capexcel += 1
				SetTextOptionValue(option, _s.SuH_rank_capexcel)
				SetTextOptionValue(id27, "$SUH_rank {"+(_s.SuH_rank_capexcel + _s.SuH_rank_capexcel2)+"}")
			endIf
		elseif option == id29
			if _f.SpendStatusCap(10, 10, 10, true)
				_s.SuH_rank_capexcel2 += 1
				SetTextOptionValue(option, _s.SuH_rank_capexcel2)
				SetTextOptionValue(id27, "$SUH_rank {"+(_s.SuH_rank_capexcel + _s.SuH_rank_capexcel2)+"}")
			endIf
		elseif option == id30
			if _s.SuH_rank_capexcelplus > 0
				debug.MessageBox("Cap Excel+ Already Unlocked")
			elseif _f.SpendStatusCap(0, 60, 60, true)
				_s.SuH_rank_capexcelplus += 1
				SetTextOptionValue(option, "Unlocked")
			endIf
		elseif option == id32
			If _f.SpendStatusCap(25, 0, 0, true)
				_s.SuH_rank_formalbeauty += 1
				SetTextOptionValue(option, _s.SuH_rank_formalbeauty)
				SetTextOptionValue(id31, "$SUH_rank {"+_s.SuH_rank_formalbeauty+"}")
			endIf
		elseif option == id34
			if _f.SpendStatusCap(0, 0, 10, true)
				_s.SuH_rank_selfstacker += 1
				SetTextOptionValue(option, _s.SuH_rank_selfstacker)
				SetTextOptionValue(id33, "$SUH_rank {"+_s.SuH_rank_selfstacker+"}")
			endIf
		elseif option == id35
			if _s.SuH_rank_selfstackerplus > 0
				debug.MessageBox("Self Indulgent+ Already Unlocked")
			elseif _f.SpendStatusCap(0, 0, 120, true)
				_s.SuH_rank_selfstackerplus += 1
				SetTextOptionValue(option, "Unlocked")
			endIf
		elseif option == id37
			if _f.SpendStatusCap(5, 5, 5, true)
				_s.SuH_rank_healthyabsorber += 1
				SetTextOptionValue(option, _s.SuH_rank_healthyabsorber)
				SetTextOptionValue(id36, "$SUH_rank {"+_s.SuH_rank_healthyabsorber+"}")
			endIf
		elseif option == id39
			if	_s.SuH_rank_soultap >= 5
				debug.MessageBox("Soul Siphon has reached the max rank available on this path!")
			elseif _f.SpendStatusCap(0, 25, 0, true)
				_s.SuH_rank_soultap += 1
				SetTextOptionValue(option, _s.SuH_rank_soultap)
				SetTextOptionValue(id38, "$SUH_rank {"+_s.SuH_rank_soultap+"}")
			endIf
		elseif option == id40
			if	_s.SuH_rank_soultapplus > 0
				debug.MessageBox("Soul Siphon+ already unlocked!")
			elseif _f.SpendStatusCap(0, 80, 0, true)
				_s.SuH_rank_soultapplus += 1
				SetTextOptionValue(option, "Unlocked")
			endIf
		elseif option == id42
			if	_s.SuH_rank_perfectorgasm >= 95
				debug.MessageBox("Perfect Orgasm has reached the max rank available on this path!")
			elseif _f.SpendStatusCap(0, 15, 0, true)
				_s.SuH_rank_perfectorgasm += 1
				SetTextOptionValue(option, _s.SuH_rank_perfectorgasm)
				SetTextOptionValue(id41, "$SUH_rank {"+(_s.SuH_rank_perfectorgasm + _s.SuH_rank_perfectorgasm2)+"}")
			endIf
		elseif option == id43
			if	_s.SuH_rank_perfectorgasm2 >= 20
				debug.MessageBox("Perfect Orgasm has reached the max rank available on this path!")
			elseif _f.SpendStatusCap(15, 15, 15, true)
				_s.SuH_rank_perfectorgasm2 += 1
				SetTextOptionValue(option, _s.SuH_rank_perfectorgasm2)
				SetTextOptionValue(id41, "$SUH_rank {"+(_s.SuH_rank_perfectorgasm + _s.SuH_rank_perfectorgasm2)+"}")
			endIf
		endIf
		SetCurrencyDisplays()
	endevent
	
	event OnOptionHighlight(int option)
		if option == id0
			int y = 0
			if _s.SuH_rank_masochist2 != 0
				y = Math.Floor(_s.SuH_rank_masochist2 * (_s.SuH_PCSbpoint * 0.1))
			endIf
			int x = Math.ceiling(((Math.Floor((_s.SuH_PCSbpoint * 0.01) * _s.SuH_rank_masochist3)) * (_s.SuH_PCSxpgain * 0.01)) * _s.SuH_PCSeffectmulti)
			SetInfoText("$SUH_PASS_MASOCHIST{"+_s.SuH_rank_masochist+"}{"+y+"}{"+x+"}")
		elseif option == id1
			SetInfoText("$SUH_PASS_MASOCHISTLUST")
		elseif option == id2
			SetInfoText("$SUH_PASS_MASOCHISTSTAMINA")
		elseif option == id3
			SetInfoText("$SUH_PASS_MASOCHISTHEARTXP")
		elseif option == id4
			int spoint = _s.SuH_PCSspoint
			int r1 = _s.SuH_rank_violence
			int x = 0
			if r1 != 0
				x = Math.Floor(r1 * (spoint * 0.05))
			endif
			int r2 = _s.SuH_rank_violence2
			int y = 0
			if r2 != 0
				y = Math.Floor(r2 * (spoint * 0.05))
			endif
			int r3 = _s.SuH_rank_violence3
			int z = 0
			if r3 != 0
				z = Math.Floor(r3 * (spoint * 0.05))
			endif
			SetInfoText("$SUH_PASS_VIOLENCE{"+x+"}{"+y+"}{"+z+"}")
		elseif option == id5
			SetInfoText("$SUH_PASS_VIOLENCEHEALTH")
		elseif option == id6
			SetInfoText("$SUH_PASS_VIOLENCEMAGICKA")
		elseif option == id7
			SetInfoText("$SUH_PASS_VIOLENCESTAMINA")
		elseif option == id8
			int r1 = _s.SuH_rank_regalglow
			int y = 0
			if r1 > 0
				y = Math.Floor(r1 * (_s.SuH_PCSmpoint * 0.05))
			endIf
			SetInfoText("$SUH_PASS_REGALGLOW{"+y+"}")
		elseif option == id9
			SetInfoText("$SUH_PASS_REGALGLOWARMOR")
		elseif option == id10
			int r1 = _s.SuH_rank_savingessence
			int x = 0
			if r1 > 0
				x = Math.Floor(r1 * (_s.SuH_PCSbpoint * 0.05))
			endIf
			int y = ( 300 - (_s.SuH_rank_savingessence2 * 20) )
			SetInfoText("$SUH_PASS_SAVINGESSENCE{"+x+"}{"+y+"}")
		elseif option == id11
			SetInfoText("$SUH_PASS_SAVINGESSENCEHRECOVERY")
		elseif option == id12
			SetInfoText("$SUH_PASS_SAVINGESSENCEFLUIDCOST")
		elseif option == id13
			SetInfoText("$SUH_PASS_SEDUCER{"+(_s.SuH_rank_seducer * 10)+"}{"+(_s.SuH_rank_seducer2 * 20)+"}")
		elseif option == id14
			SetInfoText("$SUH_PASS_SEDUCERSUCCESSRATE")
		elseif option == id15
			SetInfoText("$SUH_PASS_SEDUCERLUSTRESIST")
		elseif option == id16
			SetInfoText("$SUH_PASS_DEVIOUSPARTNER{"+(_s.SuH_rank_deviouspartner * 20)+"}{"+(Math.Floor(_s.SuH_PCSdpoint * 0.4))+"}{"+(_s.SuH_rank_deviouspartner2 * 10)+"}")
		elseif option == id17
			SetInfoText("$SUH_PASS_DEVIOUSPARTNERGOLD")
		elseif option == id18
			SetInfoText("$SUH_PASS_DEVIOUSPARTNERITEM")
		elseif option == id19
			string m = " [Applies before drain if consent drain is enabled]"
			if _s.SuH_rank_giftedconsentplus > 0
				m = "Gifted Consent+ Unlocked : Consensual partners do not lose Max Status from drain but your Succubus' benefits start at 10% of their normal drain."
			endIf
			SetInfoText("$SUH_PASS_GIFTEDCON{"+_s.SuH_rank_giftedconsent+"}{"+m+"}")
		elseif option == id20
			SetInfoText("$SUH_PASS_GIFTEDCONMAXSTATUS")
		elseif option == id21
			SetInfoText("$SUH_PASS_GIFTEDCONPLUS")
		elseif option == id22
			SetInfoText("$SUH_PASS_INCREASERATING")
		elseif option == id23
			SetInfoText("$SUH_PASS_RESETPASSACTIVE")
		elseif option == id24
			int r1 = _s.SuH_rank_lusciousliquids
			int r2 = (_s.SuH_rank_lusciousliquids2 * 5)
			int x = 0
			if r1 > 0
				x = Math.Floor(r1 * (_s.SuH_PCSdpoint * 0.1))
			endIf
			SetInfoText("$SUH_PASS_LUSCIOUS{"+x+"}{"+r2+"}")
		elseif option == id25
			SetInfoText("$SUH_PASS_LUSCIOUSRECOVERY")
		elseif option == id26
			SetInfoText("$SUH_PASS_LUSCIOUSBONUS")
		elseif option == id27
			int x = Math.Floor((_s.SuH_PCSbpoint * 0.2) * _s.SuH_rank_capexcel)
			string m = ""
			if _s.SuH_rank_capexcelplus > 0
				m = " Cap Excel+ is unlocked, while Sex Bonus is active Status won't decay."
			endIf
			SetInfoText("$SUH_PASS_CAPEXCEL{"+x+"}{"+_s.SuH_rank_capexcel2+"}{"+m+"}")
		elseif option == id28
			SetInfoText("$SUH_PASS_CAPEXCELPOTENTIAL")
		elseif option == id29
			SetInfoText("$SUH_PASS_CAPEXCELDECAY")
		elseif option == id30
			SetInfoText("$SUH_PASS_CAPEXCELPLUS")
		elseif option == id31
			int r1 = _s.SuH_rank_formalbeauty as int
			int x = 0
			if r1 > 0
				x = Math.Floor(r1 * (_s.SuH_PCSdpoint * 0.05))
			endIf
			SetInfoText("$SUH_PASS_FORMALB{"+x+"}")
		elseif option == id32
			SetInfoText("$SUH_PASS_FORMALBRECOVERY")
		elseif option == id33
			int x = (_s.SuH_rank_selfstacker * 5)
			string m = ""
			if _s.SuH_rank_selfstackerplus > 0
				m = " Self Indulgent+ Unlocked : Gain Sex Bonus in solo acts. "
			endIf
			SetInfoText("$SUH_PASS_SELFINDULGE{"+x+"}{"+m+"}")
		elseif option == id34
			SetInfoText("$SUH_PASS_SELFINDULGESBONUS")
		elseif option == id35
			SetInfoText("$SUH_PASS_SELFINDULGEPLUS")
		elseif option == id36
			SetInfoText("$SUH_PASS_HEALTHYABSORB{"+(_s.SuH_rank_healthyabsorber * 25)+"}")
		elseif option == id37
			SetInfoText("$SUH_PASS_HEALTHYABSORBHEALING")
		elseif option == id38
			SetInfoText("$SUH_PASS_SOULSIPHON{"+(_s.SuH_rank_soultap * 20)+"}")
		elseif option == id39
			SetInfoText("$SUH_PASS_SOULSIPHONTRAP")
		elseif option == id40
			SetInfoText("$SUH_PASS_SOULSIPHONPLUS")
		elseif option == id41
			SetInfoText("$SUH_PASS_PERFECTORGASM{"+_s.SuH_rank_perfectorgasm+"}{"+(_s.SuH_rank_perfectorgasm2*5)+"}")
		elseif option == id42
			SetInfoText("$SUH_PASS_PERFECTORGASMRARE")
		elseif option == id43
			SetInfoText("$SUH_PASS_PERFECTORGASMDEATH")
		else
			AllOptionHighlightCheck(option)
		endif
	endevent

endstate

; Actives Page
state PAGE_ACTIVES

	function SetUpPage()
		if seen_actives != true
			debug.MessageBox("< Actives > \n Spend/Decrease Status Caps to unlock or strengthen your Active Succubus Abilities. Active Abilities gain additional bonuses based on your BDSM Rating. BDSM Rating is improved when increasing Heart Levels.")
			seen_actives = true
		endIf
		
		string sexualenticestring = "Tier 1"
		if _s.SuH_rank_sexualentice == 2
			sexualenticestring = "Tier 2"
		elseif _s.SuH_rank_sexualentice > 2
			sexualenticestring = "[Tier 3]"
		endIf
		
		string sexualenragestring = "Tier 1"
		if _s.SuH_rank_sexualenrage == 2
			sexualenragestring = "Tier 2"
		elseif _s.SuH_rank_sexualenrage > 2
			sexualenragestring = "[Tier 3]"
		endIf
		int passiveresetcost = passiveresetcostcalc()
		
		SetCursorFillMode(TOP_TO_BOTTOM)
		
		;	Left Side
		SetCursorPosition(0)
		status_display = AddTextOption("Status ", "H:"+_s.SuH_PCScaphealth+"  M:"+_s.SuH_PCScapmagicka+"  S:"+_s.SuH_PCScapstamina)
		AddHeaderOption("$SUH_Seduction Spells")
		id0 = AddTextOption("$SUH_Sexual Entice", sexualenticestring)
		id1 = AddTextOption("$SUH_= Improve", " ")
		id2 = AddTextOption("$SUH_Sexual Enrage", sexualenragestring)
		id3 = AddTextOption("$SUH_= Improve", " ")
		id4 = AddTextOption("$SUH_Sexual Embrace", "[Tier 1]")

		;	Right Side
		SetCursorPosition(1)
		id5 = AddTextOption("$SUH_>>> Reset Passives/Actives", passiveresetcost+" XP")
	endfunction

	event OnOptionSelect(int option)
		if option == id1
			if _s.SuH_rank_sexualentice > 2 ; Caps at tier 3
				debug.MessageBox("Sexual Entice has reached its max available Tier")
			elseif _f.SpendStatusCap(25, 25, 25, true)
				_s.SuH_rank_sexualentice += 1
				if _s.SuH_rank_sexualentice == 2
					SetTextOptionValue(option, "Tier 2")
				else
					SetTextOptionValue(option, "[Tier 3]")
				endIf
			endIf
		elseif option == id2
			if _s.SuH_rank_sexualenrage > 2 ; Caps at tier 3
				debug.MessageBox("Sexual Enrage has reached its max available Tier")
			elseif _f.SpendStatusCap(25, 25, 25, true)
				_s.SuH_rank_sexualenrage += 1
				if _s.SuH_rank_sexualenrage == 2
					SetTextOptionValue(option, "Tier 2")
				else
					SetTextOptionValue(option, "[Tier 3]")
				endIf
			endIf
		elseif option == id5
			_f.PassiveReset()
			ForcePageReset()
		endif
	endevent

	event OnOptionHighlight(int option)
		if option == id0
			int x = (5 + ((_s.SuH_rank_seducer * 10 ) + (_s.SuH_rank_sexualentice * 15)))
			int y = (110 - (_s.SuH_rank_sexualentice * 10)) ; Start at 100 cost, reduce by 10 each rank
			SetInfoText("$SUH_ACTIVES_SEXUALENTICE{"+x+"}{"+y+"}")
		elseif option == id1
			SetInfoText("$SUH_ACTIVES_SEXUALENTICEIMPROVE")
		elseif option == id2
			int x = (5 + ((_s.SuH_rank_seducer * 10) + (_s.SuH_rank_sexualenrage * 15)))
			int y = (45 - (_s.SuH_rank_sexualenrage * 5)) ; Start at 40 cost, reduce by 5 each rank
			SetInfoText("$SUH_ACTIVES_SEXUALENRAGE{"+x+"}{"+y+"}")
		elseif option == id3
			SetInfoText("$SUH_ACTIVES_SEXUALENRAGEIMPROVE")
		elseif option == id4
			SetInfoText("$SUH_ACTIVES_SEXUALEMBRACE")
		elseif option == id5
			SetInfoText("$SUH_ACTIVES_RESET")
		else
			AllOptionHighlightCheck(option)
		endif
	endevent

endstate

state PAGE_SOULPETS

	function SetUpPage()
		if seen_soul != true
			debug.MessageBox("< Soul Pets > \n MCM for managing your Soul Pets. When souls have been replicated they'll show up here, select their slot for various options. Soul Pets will level up and strengthen through gameplay.")
			seen_soul = true
		endIf
		;	Variables
		if _s.SuH_petactorbases[petselectedslot] == none ; if selected slot is invalid
			petselectedslot = 0 ; Pet Slot currently selected, default to first slot
		endIf
		
		petslotarray = new int[25] ; Array for Pet Slot entries
		petselectarray = new bool[25] ; Selection array for which pet slot is selected
		petselectarray[petselectedslot] = true ; Show enabled pet
		petmenuoption = 0 ; Action selected, such as "Swap Slot"
		petdeletewarning = 0 ; number of warnings before deleting a pet
		string petActiveStatus = "Returned" ; Active Pet Status, default to returned
		if _s.SuH_petactoralive[petselectedslot].IsDisabled() == false ; check if enabled, which should mean actively in game world
			if _s.SuH_Frame_Sexlab > 0 && _s.SexLab.ValidateActor(_s.SuH_petactoralive[petselectedslot]) == -10
				petActiveStatus = "In-Act" ; set text to In-Act
			else
				petActiveStatus = "Summoned" ; set text to summoned
			endIf
		endIf
		
		string activePetName = " "
		if _s.SuH_petactive >= 0
			activePetName = _s.SuH_petnames[_s.SuH_petactive]
		endIf
		
		string petTrait0 = " - - - "
		if _s.SuH_pettrait0[petselectedslot] > 0
			petTrait0 = _f.PetGetTraitName(_s.SuH_pettrait0[petselectedslot])
		endIf
		string petTrait1 = " - - - "
		if _s.SuH_pettrait1[petselectedslot] > 0
			petTrait1 = _f.PetGetTraitName(_s.SuH_pettrait1[petselectedslot])
		endIf
		string petTrait2 = " - - - "
		if _s.SuH_pettrait2[petselectedslot] > 0
			petTrait2 = _f.PetGetTraitName(_s.SuH_pettrait2[petselectedslot])
		endIf
		
		SetCursorFillMode(TOP_TO_BOTTOM)
		
		;	Left Side
		SetCursorPosition(0)
		id0 = AddTextOption("$SUH_Soul Pet Skill Level", _s.SuH_petskill)
		id3 = AddTextOption(" ", " ") ; Display current action "tooltip" such as "Select slot to swap with "
		AddHeaderOption("Pet Souls")
		
		int i = 0 ; Create neccessary Soul Pet entries, has a max of 25 entries
		while i < _s.SuH_petactorbases.Length
			if _s.SuH_petactorbases[i] != none
				petslotarray[i] = AddToggleOption((_s.SuH_petnames[i])+" (level "+_s.SuH_petlevels[i]+")", petselectarray[i])
			endIf
			i += 1
		endWhile
			
		;	Right Side
		SetCursorPosition(1)
		id1 = AddTextOption("$SUH_Active Pet", activePetName) ;pet.activepet
		id2 = AddTextOption("$SUH_Selected Pet", _s.SuH_petnames[petselectedslot]) ;pet.activepet
		AddHeaderOption("$SUH_Pet Options")
		id6 = AddTextOption("$SUH_Dismiss Active Pet", " ")
		id5 = AddTextOption("$SUH_Summon Selected Pet", " ")
		id7 = AddTextOption("$SUH_Unsummon Selected Pet", " ")
		id8 = AddInputOption("$SUH_Rename Selected Pet", " ")
		id9 = AddTextOption("$SUH_Swap Pet Slot", " ")
		AddHeaderOption("$SUH_Pet Status")
		id10 = AddTextOption("$SUH_Pet Active Status", petActiveStatus)
		id11 = AddTextOption("$SUH_Pet Traits", " - - - ")
		id12 = AddTextOption(" ", petTrait0)
		id13 = AddTextOption(" ", petTrait1)
		id14 = AddTextOption(" ", petTrait2)
		id15 = AddMenuOption("$SUH_Remove Pet Trait", "[30 Blood Chips]")
		id4 = AddTextOption("$SUH_Remove Pet", " ")
	endfunction

	event OnOptionMenuOpen(int option)
		if option == id15
			string[] menuoptions = new string[4]
			menuoptions[0] = "Cancel / Don't Remove Any Trait"
			menuoptions[1] = _f.PetGetTraitName(_s.SuH_pettrait0[petselectedslot])
			menuoptions[2] = _f.PetGetTraitName(_s.SuH_pettrait1[petselectedslot])
			menuoptions[3] = _f.PetGetTraitName(_s.SuH_pettrait2[petselectedslot])
			SetMenuDialogOptions(menuoptions)
			SetMenuDialogStartIndex(0)
			SetMenuDialogDefaultIndex(0)
		endIf
	endevent

	event OnOptionMenuAccept(int option, int index)
		if option == id15
			if index == 0
				return ; Cancelled, do nothing
			endif
			if PlayerRef.GetItemCount(_s.SuH_misc_bloodchip) < 30
				Debug.MessageBox(": Soul Pets :\nNot Enough Blood Chips\nRequires 30 Blood Chips to remove a Pet Trait")
			elseif index == 1 ; Slot 0
				if _s.SuH_pettrait0[petselectedslot] > 0 ; if has trait, remove slot and collapse traits, change MCM display
					PlayerRef.RemoveItem(_s.SuH_misc_bloodchip, 30) ; remove blood chip cost
					string pettraitname = _f.PetGetTraitName(_s.SuH_pettrait0[petselectedslot])
					_s.SuH_pettrait0[petselectedslot] = _s.SuH_pettrait1[petselectedslot]
					if _s.SuH_pettrait0[petselectedslot] > 0
						SetTextOptionValue(id12, _f.PetGetTraitName(_s.SuH_pettrait0[petselectedslot]))
					else
						SetTextOptionValue(id12, " - - - ")
					endIf
					_s.SuH_pettrait1[petselectedslot] = _s.SuH_pettrait2[petselectedslot]
					if _s.SuH_pettrait1[petselectedslot] > 0
						SetTextOptionValue(id13, _f.PetGetTraitName(_s.SuH_pettrait1[petselectedslot]))
					else
						SetTextOptionValue(id13, " - - - ")
					endIf
					_s.SuH_pettrait2[petselectedslot] = 0
					SetTextOptionValue(id14, " - - - ")
					_f.PetReapplyTraits(petselectedslot)
					Debug.MessageBox(": Soul Pets :\nPet Trait "+pettraitname+" Removed.\n30 Blood Chips Removed")
				endIf
			elseif index == 2 ; Slot 1
				if _s.SuH_pettrait1[petselectedslot] > 0 ; if has trait, remove slot and collapse traits, change MCM display
					PlayerRef.RemoveItem(_s.SuH_misc_bloodchip, 30) ; remove blood chip cost
					string pettraitname = _f.PetGetTraitName(_s.SuH_pettrait1[petselectedslot])
					_s.SuH_pettrait1[petselectedslot] = _s.SuH_pettrait2[petselectedslot]
					if _s.SuH_pettrait1[petselectedslot] > 0
						SetTextOptionValue(id13, _f.PetGetTraitName(_s.SuH_pettrait1[petselectedslot]))
					else
						SetTextOptionValue(id13, " - - - ")
					endIf
					_s.SuH_pettrait2[petselectedslot] = 0
					SetTextOptionValue(id14, " - - - ")
					_f.PetReapplyTraits(petselectedslot)
					Debug.MessageBox(": Soul Pets :\nPet Trait "+pettraitname+" Removed.\n30 Blood Chips Removed")
				endIf
			elseif index == 3 ; Slot 2
				if _s.SuH_pettrait2[petselectedslot] > 0 ; if has trait, remove slot and collapse traits, change MCM display
					PlayerRef.RemoveItem(_s.SuH_misc_bloodchip, 30) ; remove blood chip cost
					string pettraitname = _f.PetGetTraitName(_s.SuH_pettrait2[petselectedslot])
					_s.SuH_pettrait2[petselectedslot] = 0
					SetTextOptionValue(id14, " - - - ")
					_f.PetReapplyTraits(petselectedslot)
					Debug.MessageBox(": Soul Pets :\nPet Trait "+pettraitname+" Removed.\n30 Blood Chips Removed")
				endIf
			endIf
		endIf
	endevent

	event OnOptionInputOpen(int option)
		if(option == id8) ; rename pet
			SetInputDialogStartText(_s.SuH_petnames[petselectedslot])
		endIf
	endevent

	event OnOptionInputAccept(int option, string isnotavariablemyfuckingasspapyrusshutup)
		if(option == id8) ; rename pet
			if isnotavariablemyfuckingasspapyrusshutup != ""
				_s.SuH_petnames[petselectedslot] = ""
				string petname = isnotavariablemyfuckingasspapyrusshutup
				int i = 0
				int x = 0
				while i < _s.SuH_petnames.length
					if petname == _s.SuH_petnames[i]
						x += 1
						petname = isnotavariablemyfuckingasspapyrusshutup+x
						i = 0
					else
						i += 1
					endIf
				endwhile
				_s.SuH_petnames[petselectedslot] = petname
				ForcePageReset() ; Reset page to update names in pet slots correctly
			endIf
		endIf
	endevent

	event OnOptionSelect(int option)
		int resetwarning = 1
		if option == id5 ; summon pet
			if _s.SuH_petactorbases[petselectedslot] != none
				_f.SoulPetSummon(petselectedslot) ; summon pet and display message
				debug.MessageBox(_s.SuH_petnames[petselectedslot]+" Summoned")
				SetTextOptionValue(id1, _s.SuH_petnames[_s.SuH_petactive]) ; update selected pet name display
				SetTextOptionValue(id10, "Summoned") ; update Active Status display
			endIf
		elseif option == id6 ; dismiss active pet
			if _s.SuH_petactive >= 0
				_f.SoulPetDismiss() ; dismiss pet and display message
				debug.MessageBox("Active Pet "+_s.SuH_petnames[petselectedslot]+" Dismissed")
				SetTextOptionValue(id1, " ") ; update selected pet name display
			endIf
		elseif option == id7 ; unsummon selected pet
			if _s.SuH_petactoralive[petselectedslot] != none && _s.SuH_petactoralive[petselectedslot].IsDisabled() == false
				if _s.SuH_Frame_Sexlab > 0 && _s.SexLab.ValidateActor(_s.SuH_petactoralive[petselectedslot]) == -10
					debug.MessageBox("Soul Pets can't be Unsummoned while In-Act")
				else
					if petselectedslot == _s.SuH_petactive
						SetTextOptionValue(id1, " ") ; update active pet name display
					endIf
					SetTextOptionValue(id10, "Returned") ; update Active Status display
					 _f.SoulPetDeSummon(petselectedslot) ; unsummon pet and display message
					debug.MessageBox(_s.SuH_petnames[petselectedslot]+" Returned")
				endIf
			endIf
		elseif option == id9 ; Swap pet slot
			if petmenuoption != 1 ; if menu option is not swap pet
				resetwarning = 0
				petmenuoption = 1 ; set pet menu option to swap slot
				SetTextOptionValue(id3, "Select Second Slot to Swap With ") ; update selected pet name display
				debug.MessageBox("Select another slot to swap the currently selected pet slot with the newly selected pet slot. Re-select this option to cancel.")
			else
				petmenuoption = 0 ; reset menu option
			endIf
		elseif option == id4 ; Remove pet
			resetwarning = 0
			if petdeletewarning == 0
				petdeletewarning += 1
				SetTextOptionValue(id4, "Are you sure?") ; update selected pet name display
			elseif petdeletewarning == 1
				petdeletewarning += 1
				SetTextOptionValue(id4, "Are you sure you're sure?") ; update selected pet name display
			elseif petdeletewarning == 2
				if _s.SuH_Frame_Sexlab > 0 && _s.SexLab.ValidateActor(_s.SuH_petactoralive[petselectedslot]) == -10
					debug.MessageBox("Soul Pets can't be removed while In-Act")
				else
					_f.SoulPetRemove(petselectedslot) ; summon pet and display message
					petdeletewarning = 0
					ForcePageReset() ; Reset page to update pet slot count and menu entries properly
				endIf
			endIf
		else ; Pet Slot Selected?
			int i = 0 ; scan pet slot array for selected entry
			while i < petselectarray.Length
				if option == petslotarray[i] ; if slot found
					if i != petselectedslot ; if slot not already selected
						if petmenuoption == 1 ; if Swap Pet is selected
							if _s.SuH_petactorbases[i] != none ; if swap to pet is valid
								if petselectedslot == _s.SuH_petactive ; if slot selected is equal to active pet
									_s.SuH_petactive = i
								elseif i == _s.SuH_petactive ; if slot to swap to is active pet
									_s.SuH_petactive = petselectedslot
								endIf
								int x = _s.SuH_petlevels[i] ; swap levels
								_s.SuH_petlevels[i] = _s.SuH_petlevels[petselectedslot]
								_s.SuH_petlevels[petselectedslot] = x
								x = _s.SuH_petxps[i] ; swap xp
								_s.SuH_petxps[i] = _s.SuH_petxps[petselectedslot]
								_s.SuH_petxps[petselectedslot] = x
								x = _s.SuH_pettrait0[i] ; swap trait
								_s.SuH_pettrait0[i] = _s.SuH_pettrait0[petselectedslot]
								_s.SuH_pettrait0[petselectedslot] = x
								x = _s.SuH_pettrait1[i] ; swap trait
								_s.SuH_pettrait1[i] = _s.SuH_pettrait1[petselectedslot]
								_s.SuH_pettrait1[petselectedslot] = x
								x = _s.SuH_pettrait2[i] ; swap trait
								_s.SuH_pettrait2[i] = _s.SuH_pettrait2[petselectedslot]
								_s.SuH_pettrait2[petselectedslot] = x
								string y = _s.SuH_petnames[i] ; swap names
								_s.SuH_petnames[i] = _s.SuH_petnames[petselectedslot]
								_s.SuH_petnames[petselectedslot] = y
								actor k = _s.SuH_petactoralive[i] ; swap actor
								_s.SuH_petactoralive[i] = _s.SuH_petactoralive[petselectedslot]
								_s.SuH_petactoralive[petselectedslot] = k
								actorbase m = _s.SuH_petactorbases[i] ; swap actor
								_s.SuH_petactorbases[i] = _s.SuH_petactorbases[petselectedslot]
								_s.SuH_petactorbases[petselectedslot] = m
								resetwarning = 0
								petselectedslot = i
								ForcePageReset() ; reset page to update pet slots correctly
							endIf
						else
							petselectarray[petselectedslot] = false ; set old selection to false
							SetToggleOptionValue(petslotarray[petselectedslot], false) ; update menu entry
							petselectedslot = i ; set new selected slot
							petselectarray[i] = true ; set new selection to true
							SetToggleOptionValue(petslotarray[i], true) ; update menu entry
							SetTextOptionValue(id2, _s.SuH_petnames[petselectedslot]) ; update selected pet name display
							if _s.SuH_petactoralive[petselectedslot].IsDisabled() ; if pet is disabled, should indicate Returned
								SetTextOptionValue(id10, "Returned") ; update Active Status display
							elseif _s.SuH_Frame_Sexlab > 0 && _s.SexLab.ValidateActor(_s.SuH_petactoralive[petselectedslot]) == -10
								SetTextOptionValue(id10, "In-Act") ; update Active Status display
							else
								SetTextOptionValue(id10, "Summoned") ; update Active Status display
							endIf
							if _s.SuH_pettrait0[petselectedslot] > 0 ; check for pet traits, if valid rename
								SetTextOptionValue(id12, _f.PetGetTraitName(_s.SuH_pettrait0[petselectedslot])) ; update trait display
							else ; if not valid set blank entry
								SetTextOptionValue(id12, " - - - ") ; update trait display
							endIf
							if _s.SuH_pettrait1[petselectedslot] > 0
								SetTextOptionValue(id13, _f.PetGetTraitName(_s.SuH_pettrait1[petselectedslot])) ; update trait display
							else
								SetTextOptionValue(id13, " - - - ") ; update trait display
							endIf
							if _s.SuH_pettrait2[petselectedslot] > 0
								SetTextOptionValue(id14, _f.PetGetTraitName(_s.SuH_pettrait2[petselectedslot])) ; update trait display
							else
								SetTextOptionValue(id14, " - - - ") ; update trait display
							endIf
						endIf
						i = 149 ; escape array
					endIf
				endIf
				i += 1
			endWhile
		endIf
		if resetwarning > 0
			petdeletewarning = 0
			petmenuoption = 0
			SetTextOptionValue(id3, " ") ; update selected pet name display
		endIf
	endevent

	event OnOptionHighlight(int option)
		if option == id0
			SetInfoText("$SUH_SPETS_PETSKILLLEVEL")
		elseif option == id1
			SetInfoText("$SUH_SPETS_ACTIVEPET")
		elseif option == id2
			SetInfoText("$SUH_SPETS_SELECTEDPET")
		elseif option == id6
			SetInfoText("$SUH_SPETS_DISMISSACTIVEPET")
		elseif option == id5
			SetInfoText("$SUH_SPETS_SUMMONSELECTPET")
		elseif option == id7
			SetInfoText("$SUH_SPETS_UNSUMMONSELECTPET")
		elseif option == id8
			SetInfoText("$SUH_SPETS_RENAMESELECTPET")
		elseif option == id9
			SetInfoText("$SUH_SPETS_SWAPPET")
		elseif option == id4
			SetInfoText("$SUH_SPETS_REMOVEPET")
		elseif option == id10
			SetInfoText("$SUH_SPETS_ACTIVEPETSTATUS")
		elseif option == id11
			SetInfoText("$SUH_SPETS_PETTRAITS")
		elseif option == id12 || option == id13 || option == id14
			int x = 0
			if option == id12 ; Get the correct pet trait from the appropriate slot
				x = _s.SuH_pettrait0[petselectedslot]
			elseif option == id13
				x = _s.SuH_pettrait1[petselectedslot]
			else
				x = _s.SuH_pettrait2[petselectedslot]
			endIf
			SetInfoText(_f.PetGetTraitName(traitnum=x, descrip=true))
		elseif option == id15
			SetInfoText("$SUH_SPETS_REMOVETRAIT")
		else
			AllOptionHighlightCheck(option)
		endif
	endevent

endstate

state PAGE_TITLES

	function SetUpPage()
		if seen_title != true
			debug.MessageBox("< Titles > \n Earn Reputaion through various activities for bonus HeartXP.")
			seen_title = true
		endIf
		
		;	Variables
		
		SetCursorFillMode(TOP_TO_BOTTOM) ; id11
		;	Left Side
		SetCursorPosition(0)
		AddHeaderOption("Evolving Titles")
		id0 = AddTextOption(_f.PCE_gettitlename("Succubus")+" (Rank "+_s.SuH_title_succubus+")", " ")
		id1 = AddTextOption(_f.PCE_gettitlename("Drinker")+" (Rank "+_s.SuH_title_drinker+")", " ")
		id2 = AddTextOption(_f.PCE_gettitlename("Friendly")+" (Rank "+_s.SuH_title_friendly+")", " ")
		id4 = AddTextOption(_f.PCE_gettitlename("Pettrain")+" (Rank "+_s.SuH_title_pettrain+")", " ")
		id8 = AddTextOption(_f.PCE_gettitlename("OfferItem")+" (Rank "+_s.SuH_title_offeritem+")", " ")
		id9 = AddTextOption(_f.PCE_gettitlename("Seduced")+" (Rank "+_s.SuH_title_seducer+")", " ")
		
		;	Right Side
		SetCursorPosition(1)
		AddHeaderOption("Secret Titles")
		id6 = AddTextOption(_f.PCE_gettitlename("Drainkilled"), " ")
		id5 = AddTextOption(_f.PCE_gettitlename("Realmvisit"), " ")
		id10 = AddTextOption(_f.PCE_gettitlename("Statdown"), " ")
		id3 = AddTextOption(_f.PCE_gettitlename("Pethit"), " ")
		id7 = AddTextOption(_f.PCE_gettitlename("Fedchest"), " ")
	endfunction

	event OnOptionHighlight(int option)
		if option == id0
			SetInfoText("$SUH_TITLE_SUCCUBUS{"+((_s.SuH_title_succubus * 100) - _s.SuH_titlexp_succubus)+"}")
		elseif option == id1
			SetInfoText("$SUH_TITLE_DRINKER{"+((_s.SuH_title_drinker * 100) - _s.SuH_titlexp_drinker)+"}")
		elseif option == id2
			SetInfoText("$SUH_TITLE_FRIENDLY{"+((_s.SuH_title_friendly * 100) - _s.SuH_titlexp_friendly)+"}")
		elseif option == id4
			SetInfoText("$SUH_TITLE_PETTRAIN{"+((_s.SuH_title_pettrain * 100) - _s.SuH_titlexp_pettrain)+"}")
		elseif option == id8 
			SetInfoText("$SUH_TITLE_OFFERITEM{"+((_s.SuH_title_offeritem * 100) - _s.SuH_titlexp_offeritem)+"}")
		elseif option == id9
			SetInfoText("$SUH_TITLE_SEDUCER{"+((_s.SuH_title_seducer * 100) - _s.SuH_titlexp_seducer)+"}")
			
		elseif(option == id3)
			if _s.SuH_title_pethit < 20
				SetInfoText("$SUH_TITLE_PETHIT0")
			else
				SetInfoText("$SUH_TITLE_PETHIT1")
			endIf
		elseif(option == id5)
			if _s.SuH_title_realmvisit < 1
				SetInfoText("$SUH_TITLE_REALMVISIT0")
			else
				SetInfoText("$SUH_TITLE_REALMVISIT1")
			endIf
		elseif(option == id6)
			if _s.SuH_title_drainkilled < 1
				SetInfoText("$SUH_TITLE_DRAINKILLED0")
			else
				SetInfoText("$SUH_TITLE_DRAINKILLED1")
			endIf
		elseif(option == id7)
			if _s.SuH_title_fedchest < 10000
				SetInfoText("$SUH_TITLE_FEDCHEST0")
			else
				SetInfoText("$SUH_TITLE_FEDCHEST1")
			endIf
		elseif(option == id10)
			if _s.SuH_title_statdown < 1
				SetInfoText("$SUH_TITLE_STATDOWN0")
			else
				SetInfoText("$SUH_TITLE_STATDOWN1")
			endIf
		endIf
	endevent

endstate

state PAGE_SETTINGS

	function SetUpPage()
		if seen_settings != true
			debug.MessageBox("< Settings > \n  Enable and Customize various aspects of Succubus Heart. Very important for a first time set-up!")
			seen_settings = true
		endIf
		; Variables
		int SETpetspells = 0
		if playerref.HasSpell(_s.SuH_spell_petself)
			SETpetspells = 1
		endIF
		
		bool hostilevigil = false
		if playerref.IsInFaction(_s.SuH_Vigilhostile)
			hostilevigil = true
		endIf
		
		string forcedrespawndisplay = "Disabled"
		if _s.SuH_SETrandomdeathspawn == 1
			forcedrespawndisplay = "Random Location"
		elseif _s.SuH_SETrandomdeathspawn == 2
			forcedrespawndisplay = "Last Entrance"
		endIf
		
		string drainaffectnpc = "No NPCs"
		if _s.SuH_SETnpcabsorb == 1
			drainaffectnpc = "All NPCs"
		elseif _s.SuH_SETnpcabsorb == 2
			drainaffectnpc = "Non-Allies"
		elseif _s.SuH_SETnpcabsorb == 3
			drainaffectnpc = "Hostile Only"
		endIf
		
		string drainkillallow = "Never"
		if _s.SuH_SETallowdrainkill == 1
			drainkillallow = "Always"
		elseif _s.SuH_SETallowdrainkill == 2
			drainkillallow = "Non-Allies"
		elseif _s.SuH_SETallowdrainkill == 3
			drainkillallow = "Hostile Only"
		endIf
		
		SetCursorFillMode(TOP_TO_BOTTOM)
		
		;	Left Side
		SetCursorPosition(0)
			
		AddHeaderOption("$SUH_General Options")
		id40 = AddToggleOption("$SUH_Use SPID for Dynamic Scripts", _s.SuH_SETdynaspid)
		id46 = AddToggleOption("$SUH_Only Use Framework Pref.", _s.SuH_SETonlyframepref)
		id8 = AddToggleOption("$SUH_Allow Death Drops", _s.SuH_SETdeathdrops) ;status.deathdrops
		id39 = AddToggleOption("$SUH_Females Give Milk", _s.SuH_SETmilkdistribute) ;status.milkdistribute
		id41 = AddToggleOption("$SUH_Males Give Sperm", _s.SuH_SETspermdistribute) ;status.SuH_SETspermdistribute
		id7 = AddToggleOption("$SUH_Calm Enemies During Sex", _s.SuH_SETcalmaura) ;calmaura
		id44 = AddToggleOption("$SUH_Prevent Deaths During Sex", _s.SuH_SETpreventactdeath) ;SuH_SETpreventactdeath
		id43 = AddToggleOption("$SUH_Attempt SexLab AI Bug Fix", _s.SuH_SETslaifix) ;SuH_SETslaifix
		id47 = AddToggleOption("$SUH_Allow Control Override", _s.SuH_SETchangecontrol) ;SuH_SETchangecontrol
		id12 = AddToggleOption("$SUH_Hostile Vigil. of Stendarr", hostilevigil) ;hostilevigilfaction
		id45 = AddToggleOption("$SUH_Realm Spells Cost Magicka", _s.SuH_SETrealmspellcost) ;SuH_SETrealmspellcost
		AddEmptyOption()
		
		AddHeaderOption("$SUH_Lust Options") ; Arousal Options
		id10 = AddSliderOption("$SUH_Lust Gain Multiplier", Math.Floor(_s.SuH_PCSarousalgainmulti * 100), "{0}%")
		id18 = AddToggleOption("$SUH_Lust Defects", _s.SuH_SETarousaldefect)
		id48 = AddToggleOption("$SUH_Display Pheromone Message", _s.SuH_SETpheromessage)
		AddEmptyOption()
		
		AddHeaderOption("$SUH_Sexual Drain Options") ; Sexual Drain Options
		id0 = AddSliderOption("$SUH_HeartXP Multiplier",Math.Floor(100 * _s.SuH_PCSeffectmulti), "{0}%")
		id1 = AddMenuOption("$SUH_Drain Affects NPC Status", drainaffectnpc)
		id2 = AddToggleOption("$SUH_Always Get Drain Benfits", _s.SuH_SETalwaysabsorbbenefit)
		id4 = AddMenuOption("$SUH_Allow Drain to Kill", drainkillallow)
		id5 = AddToggleOption("$SUH_Drain Always Kills", _s.SuH_SETalwaysdrainkill)
		id42 = AddToggleOption("$SUH_Drain Visuals During Act", _s.SuH_SETdrainvisualinact) ;status.alwaysdrainkill
		id6 = AddToggleOption("$SUH_Drain Resets on Orgasm", _s.SuH_SETdrainresetorgasm)
		AddEmptyOption()
		
		AddHeaderOption("$SUH_Animation Options") ; Animation Options
		id15 = AddToggleOption("$SUH_Allow Male Homosexuals", _s.SuH_SETallowmalehomo) ;status.malehomo
		id16 = AddToggleOption("$SUH_Allow Female Homosexuals", _s.SuH_SETallowfemalehomo) ;status.femalehomo
		id17 = AddToggleOption("$SUH_Force Cowgirl for F.Aggressor", _s.SuH_SETrestrictact) ;status.restricact
		id13 = AddToggleOption("$SUH_End Sex When Attacked", _s.SuH_SETactendonatk) ;status.endactonatk
		id14 = AddToggleOption("$SUH_Clean Arrows off Player", _s.SuH_SETclearactor) ;status.clearactor
			
		;	Right Side
		SetCursorPosition(1)
		
		AddHeaderOption("$SUH_Soul Pet Options") ; Soul Pet Options
		id19 = AddToggleOption("$SUH_Display Base Soul Pet Spells", SETpetspells) ;status.petspells
		id20 = AddToggleOption("$SUH_Remove Soul Pets On Death", _s.SuH_SETpetremoveondeath) ;status.removepet
		id3 = AddToggleOption("$SUH_Dismiss When Summoning Pet", _s.SuH_SETpetnewsumdismiss) ;status.dismisspet
		id9 = AddToggleOption("$SUH_Don't Unfollow", _s.SuH_SETpetstayfollowing) ;status.petstayfollowing
		id11 = AddToggleOption("$SUH_Act Traits won't kill", _s.SuH_SETtraitwontkill) ;_s.SuH_SETtraitwontkill
		
		AddEmptyOption()
		
		AddHeaderOption("$SUH_Combat Seduction Options")
		id21 = AddToggleOption("$SUH_Enable Combat Seduction", _s.SuH_SETcombatseduction)
		id49 = AddToggleOption("$SUH_Display Confirm Message", _s.SuH_CSConfirmMessage)
		id22 = AddSliderOption("$SUH_Submit Cooldown", _s.SuH_SETcscooldown, "{0} Seconds")
		id23 = AddSliderOption("$SUH_Player to NPC below..", Math.Floor(_s.SuH_SETpc2npchealth*100), "{0}% Health")
		id24 = AddSliderOption("$SUH_Player to NPC below..", Math.Floor(_s.SuH_SETpc2npchealthmin), "{0} Health")
		id25 = AddSliderOption("$SUH_Player to NPC below..", Math.Floor(_s.SuH_SETpc2npcstamina*100), "{0}% Stamina")
		id26 = AddSliderOption("$SUH_NPC to PC below..", Math.Floor(_s.SuH_SETnpc2pchealth*100), "{0}% Health")
		id27 = AddSliderOption("$SUH_NPC to PC below..", Math.Floor(_s.SuH_SETnpc2pchealthmin), "{0} Health")
		id28 = AddSliderOption("$SUH_NPC to NPC below..", Math.Floor(_s.SuH_SETnpc2npchealth*100), "{0}% Health")
		id29 = AddSliderOption("$SUH_NPC to NPC below..", Math.Floor(_s.SuH_SETnpc2npchealthmin), "{0} Health")
		AddEmptyOption()
		
		AddHeaderOption("$SUH_Death Override Mode Options") ; DOM Options
		id30 = AddToggleOption("$SUH_Enabled Death Override Mode", _s.SuH_SETspecialdeath) ;status.dom
		id31 = AddMenuOption("$SUH_Forced Respawn Location", forcedrespawndisplay) ;status.randomdeathspawm
		id32 = AddToggleOption("$SUH_Lose Items on Death", _s.SuH_SETsdloseitems) ;status.loseitems
		id33 = AddToggleOption("$SUH_Lose Gold on Death", _s.SuH_SETsdlosegold) ;status.losegold
		id34 = AddToggleOption("$SUH_Lose Blood Chips on Death", _s.SuH_SETsdlosebloodchips) ;status.losebloodchips
		id35 = AddToggleOption("$SUH_Destroy Equipped Items on Death", _s.SuH_SETsdloseequip) ;status.loseequip
		id36 = AddSliderOption("$SUH_Revival Cost", Math.Floor(_s.SuH_SETrevivecost*100), "{0}% Max Status") ;status.SETrevivecost
		id37 = AddSliderOption("$SUH_Bleed Out Delay", _s.SuH_SETcsbleedoutdelay, "{0} Sec") ;status.csbleedoutdelay
		id38 = AddToggleOption("$SUH_Never Die Mode", _s.SuH_SETneverdiemode) ;neverdie
		AddEmptyOption()
		AddEmptyOption()
	endfunction

	event OnOptionMenuOpen(int option)
		if option == id1 ;setnpcabsorb
			string[] menuoptions = new string[4]
			menuoptions[0] = "No NPCs"
			menuoptions[1] = "All NPCs"
			menuoptions[2] = "Non-Allies"
			menuoptions[3] = "Hostile Only"
			SetMenuDialogOptions(menuoptions)
			SetMenuDialogStartIndex(_s.SuH_SETnpcabsorb)
			SetMenuDialogDefaultIndex(1)
		elseif option == id4 ;drainkill
			string[] menuoptions = new string[4]
			menuoptions[0] = "Never"
			menuoptions[1] = "Always"
			menuoptions[2] = "Non-Allies"
			menuoptions[3] = "Hostile Only"
			SetMenuDialogOptions(menuoptions)
			SetMenuDialogStartIndex(_s.SuH_SETallowdrainkill)
			SetMenuDialogDefaultIndex(1)
		elseif option == id31
			string[] menuoptions = new string[3]
			menuoptions[0] = "Disabled"
			menuoptions[1] = "Random Location"
			menuoptions[2] = "Last Entrance (Default)"
			SetMenuDialogOptions(menuoptions)
			SetMenuDialogStartIndex(_s.SuH_SETrandomdeathspawn)
			SetMenuDialogDefaultIndex(2)
		endIf
	endevent

	event OnOptionMenuAccept(int option, int index)
		if option == id1 ;setnpcabsorb
			if index == 0
				_s.SuH_SETnpcabsorb = 0
				SetMenuOptionValue(id1, "No NPCs")
			elseif index == 1
				_s.SuH_SETnpcabsorb = 1
				SetMenuOptionValue(id1, "All NPCs")
			elseif index == 2
				_s.SuH_SETnpcabsorb = 2
				SetMenuOptionValue(id1, "Non-Allies")
			elseif index == 3
				_s.SuH_SETnpcabsorb = 3
				SetMenuOptionValue(id1, "Hostile Only")
			endIf
		elseif option == id4 ;drainkill
			if index == 0
				_s.SuH_SETallowdrainkill = 0
				SetMenuOptionValue(id4, "Never")
			elseif index == 1
				_s.SuH_SETallowdrainkill = 1
				SetMenuOptionValue(id4, "Always")
			elseif index == 2
				_s.SuH_SETallowdrainkill = 2
				SetMenuOptionValue(id4, "Non-Allies")
			elseif index == 3
				_s.SuH_SETallowdrainkill = 3
				SetMenuOptionValue(id4, "Hostile Only")
			endIf
		elseif option == id31
			if index == 0
				_s.SuH_SETrandomdeathspawn = 0
				SetMenuOptionValue(id31, "Disabled")
			elseif index == 1
				_s.SuH_SETrandomdeathspawn = 1
				SetMenuOptionValue(id31, "Random Location")
			elseif index == 2
				_s.SuH_SETrandomdeathspawn = 2
				SetMenuOptionValue(id31, "Last Entrance")
			endIf
		endIf
	endevent

	event OnOptionSliderOpen(int option)
		If(option == id0) ;effectmulti
			SetSliderDialogStartValue(_s.SuH_PCSeffectmulti * 100.0)
			SetSliderDialogDefaultValue(100)
			SetSliderDialogRange(0,1000)
			SetSliderDialogInterval(1)
			
		elseIf(option == id10) ;SuH_PCSarousalgainmulti
			SetSliderDialogStartValue(_s.SuH_PCSarousalgainmulti * 100)
			SetSliderDialogDefaultValue(100)
			SetSliderDialogRange(0,1000)
			SetSliderDialogInterval(1)
		
		elseIf(option == id22) ;status.cscooldown
			SetSliderDialogStartValue(_s.SuH_SETcscooldown)
			SetSliderDialogDefaultValue(10)
			SetSliderDialogRange(0,1800)
			SetSliderDialogInterval(1)
			
		elseIf(option == id23) ;status.pctonpchealth
			SetSliderDialogStartValue(_s.SuH_SETpc2npchealth*100)
			SetSliderDialogDefaultValue(30)
			SetSliderDialogRange(0,100)
			SetSliderDialogInterval(1)
			
		elseIf(option == id24) ;status.pctonpchealthmin
			SetSliderDialogStartValue(_s.SuH_SETpc2npchealthmin)
			SetSliderDialogDefaultValue(20)
			SetSliderDialogRange(0,100000)
			SetSliderDialogInterval(1)
			
		elseIf(option == id25) ;status.pctonpcstamina
			SetSliderDialogStartValue(_s.SuH_SETpc2npcstamina*100)
			SetSliderDialogDefaultValue(30)
			SetSliderDialogRange(0,100)
			SetSliderDialogInterval(1)
			
		elseif(option == id26) ;status.npctopchealth
			SetSliderDialogStartValue(_s.SuH_SETnpc2pchealth*100)
			SetSliderDialogDefaultValue(30)
			SetSliderDialogRange(0,100)
			SetSliderDialogInterval(1)
			
		elseif(option == id27) ;status.npctolchealthmin
			SetSliderDialogStartValue(_s.SuH_SETnpc2pchealthmin)
			SetSliderDialogDefaultValue(20)
			SetSliderDialogRange(0,100000)
			SetSliderDialogInterval(1)
			
		elseIf(option == id28) ;status.npctonpchealth
			SetSliderDialogStartValue(_s.SuH_SETnpc2npchealth*100)
			SetSliderDialogDefaultValue(30)
			SetSliderDialogRange(0,100)
			SetSliderDialogInterval(1)
			
		elseIf(option == id29) ;status.npctonpchealthmin
			SetSliderDialogStartValue(_s.SuH_SETnpc2npchealthmin)
			SetSliderDialogDefaultValue(20)
			SetSliderDialogRange(0,100000)
			SetSliderDialogInterval(1)
		elseIf(option == id36) ;status.SETrevivecost
			SetSliderDialogStartValue(_s.SuH_SETrevivecost)
			SetSliderDialogDefaultValue(0)
			SetSliderDialogRange(0,100)
			SetSliderDialogInterval(1)
		elseIf(option == id37) ;status.csbleedoutdelay
			SetSliderDialogStartValue(_s.SuH_SETcsbleedoutdelay)
			SetSliderDialogDefaultValue(5)
			SetSliderDialogRange(0,20)
			SetSliderDialogInterval(1.0)
		endIf
	endevent

	event OnOptionSliderAccept(int option, float value)
		if(option == id0) ;effectmulti
			_s.SuH_PCSeffectmulti = (value/100)
			SetSliderOptionValue(id0, value, "{0}%") ;effectmulti
		elseif(option == id10) ;SuH_PCSarousalgainmulti
			_s.SuH_PCSarousalgainmulti = (value/100)
			SetSliderOptionValue(id10, value, "{0}%") ; settings.desiregain
			
		elseif(option == id22) ;status.cscooldown
			_s.SuH_SETcscooldown = Math.Floor(value)
			SetSliderOptionValue(id22, value, "{0} Seconds")
		
		elseif(option == id23) ;status.pctonpchealth
			_s.SuH_SETpc2npchealth = (value/100)
			SetSliderOptionValue(id23, value, "{0}% Health") ;status.pctonpchealth
			
		elseif(option == id24) ;status.pctonpchealthmin
			_s.SuH_SETpc2npchealthmin = Math.Floor(value)
			SetSliderOptionValue(id24, value, "{0} Health") ;status.pctonpchealthmin
			
		elseif(option == id25) ;status.pctonpcstamina
			_s.SuH_SETpc2npcstamina = (value/100)
			SetSliderOptionValue(id25, value, "{0}% Stamina") ;status.pctonpcstamina
			
		elseif(option == id26) ;status.npctopchealth
			_s.SuH_SETnpc2pchealth = (value/100)
			SetSliderOptionValue(id26, value, "{0}% Health") ;status.npctopchealth
			
		elseif(option == id27) ;status.npctolchealthmin
			_s.SuH_SETnpc2pchealthmin = Math.Floor(value)
			SetSliderOptionValue(id27, value, "{0} Health") ;status.npctolchealthmin
			
		elseif(option == id28) ;status.npctonpchealth
			_s.SuH_SETnpc2npchealth = (value/100)
			SetSliderOptionValue(id28, value, "{0}% Health") ;status.npctonpchealth
			
		elseif(option == id29) ;status.npctonpchealthmin
			_s.SuH_SETnpc2npchealthmin = Math.Floor(value)
			SetSliderOptionValue(id29, value, "{0} Health") ;status.npctonpchealthmin
			
		elseif(option == id36) ;status.SETrevivecost
			_s.SuH_SETrevivecost = (value/100)
			SetSliderOptionValue(id36, value, "{0}% Status Cap") ;status.SETrevivecost
			
		elseif(option == id37) ;status.csbleedoutdelay
			_s.SuH_SETcsbleedoutdelay = Math.Floor(value)
			SetSliderOptionValue(id37, value, "{0} Sec") ;status.csbleedoutdelay
		endIf
	endevent

	event OnOptionSelect(int option)
		if(option == id2) ;setnpcabsorb
			if _s.SuH_SETalwaysabsorbbenefit > 0
				_s.SuH_SETalwaysabsorbbenefit = 0
				SetToggleOptionValue(option, FALSE) ;setnpcabsorb
			else
				_s.SuH_SETalwaysabsorbbenefit = 1
				SetToggleOptionValue(option, TRUE) ;setnpcabsorb
			endIf
		elseif(option == id47) ;SuH_SETchangecontrol
				if _s.SuH_SETchangecontrol > 0
					_s.SuH_SETchangecontrol = 0
					SetToggleOptionValue(option, FALSE) ;setnpcabsorb
				else
					_s.SuH_SETchangecontrol = 1
					SetToggleOptionValue(option, TRUE) ;setnpcabsorb
				endIf
		elseif(option == id46) ;SuH_SETonlyframepref
			if _s.SuH_SETonlyframepref > 0
				_s.SuH_SETonlyframepref = 0
				if _s.SuH_Frame_Sexlab > 0
					_s.SuH_Frame_Sexlab = 2
				endIf
				if _s.SuH_Frame_OStim > 0
					_s.SuH_Frame_OStim = 2
				endIf
				SetToggleOptionValue(option, FALSE) ;SuH_SETonlyframepref
			else
				_s.SuH_SETonlyframepref = 1
				if _s.SuH_framework == 1
					if _s.SuH_Frame_Sexlab > 0
						_s.SuH_Frame_Sexlab = 2
					endIf
					if _s.SuH_Frame_OStim > 1
						_s.SuH_Frame_OStim = 1
					endIf
				elseif _s.SuH_framework == 2
					if _s.SuH_Frame_OStim > 0
						_s.SuH_Frame_OStim = 2
					endIf
					if _s.SuH_Frame_Sexlab > 1
						_s.SuH_Frame_Sexlab = 1
					endIf
				endIf
				SetToggleOptionValue(option, TRUE) ;SuH_SETonlyframepref
			endIf
		elseif(option == id18) ;lustdefects
			if _s.SuH_SETarousaldefect > 0
				_s.SuH_SETarousaldefect = 0
				SetToggleOptionValue(option, FALSE)
			else
				_s.SuH_SETarousaldefect = 1
				SetToggleOptionValue(option, TRUE)
			endIf
		elseif(option == id43) ;SuH_SETslaifix
			if _s.SuH_SETslaifix > 0
				_s.SuH_SETslaifix = 0
				SetToggleOptionValue(option, FALSE)
			else
				_s.SuH_SETslaifix = 1
				SetToggleOptionValue(option, TRUE)
			endIf
		elseif(option == id6) ;SuH_SETdrainresetorgasm
			if _s.SuH_SETdrainresetorgasm > 0
				_s.SuH_SETdrainresetorgasm = 0
				SetToggleOptionValue(option, FALSE)
			else
				_s.SuH_SETdrainresetorgasm = 1
				SetToggleOptionValue(option, TRUE)
			endIf
		elseif(option == id45) ;SuH_SETrealmspellcost
			if _s.SuH_SETrealmspellcost > 0
				_s.SuH_SETrealmspellcost = 0
				SetToggleOptionValue(option, FALSE)
			else
				_s.SuH_SETrealmspellcost = 1
				SetToggleOptionValue(option, TRUE)
			endIf
		elseif(option == id5) ;status.alwaysdrainkill
			if _s.SuH_SETalwaysdrainkill > 0
				_s.SuH_SETalwaysdrainkill = 0
				SetToggleOptionValue(id5, FALSE) ;status.alwaysdrainkill
			else
				_s.SuH_SETalwaysdrainkill = 1
				SetToggleOptionValue(id5, TRUE) ;status.alwaysdrainkill
			endIf
		elseif(option == id7) ;calmaura
			if _s.SuH_SETcalmaura > 0
				_s.SuH_SETcalmaura = 0
				SetToggleOptionValue(id7, FALSE) ;calmaura
			else
				_s.SuH_SETcalmaura = 1
				SetToggleOptionValue(id7, TRUE) ;calmaura
			endIf
		elseif(option == id8) ;status.deathdrops
			if _s.SuH_SETdeathdrops > 0
				_s.SuH_SETdeathdrops = 0
				SetToggleOptionValue(id8, FALSE) ;status.deathdrops
			else
				_s.SuH_SETdeathdrops = 1
				SetToggleOptionValue(id8, TRUE) ;status.deathdrops
			endIf
		elseif(option == id12) ;hostilevigilfaction
			if playerref.IsInFaction(_s.SuH_Vigilhostile)
				playerref.RemoveFromFaction(_s.SuH_Vigilhostile)
				SetToggleOptionValue(id12, False) ;hostilevigilfaction
			else
				playerref.AddToFaction(_s.SuH_Vigilhostile)
				SetToggleOptionValue(id12, True) ;hostilevigilfaction
			endIf
			
		elseif(option == id13) ;status.endactonatk
			if _s.SuH_SETactendonatk > 0
				_s.SuH_SETactendonatk = 0
				SetToggleOptionValue(id13, FALSE) ;status.endactonatk
			else
				_s.SuH_SETactendonatk = 1
				SetToggleOptionValue(id13, TRUE) ;status.endactonatk
			endIf
			
		elseif(option == id14) ;status.clearactor
			if _s.SuH_SETclearactor > 0
				_s.SuH_SETclearactor = 0
				SetToggleOptionValue(id14, FALSE) ;status.clearactor
			else
				_s.SuH_SETclearactor = 1
				SetToggleOptionValue(id14, TRUE) ;status.clearactor
			endIf
			
		elseif(option == id15) ;status.malehomo
			if _s.SuH_SETallowmalehomo > 0
				_s.SuH_SETallowmalehomo = 0
				SetToggleOptionValue(id15, FALSE) ;status.malehomo
			else
				_s.SuH_SETallowmalehomo = 1
				SetToggleOptionValue(id15, TRUE) ;status.malehomo
			endIf
			
		elseif(option == id16) ;status.femalehomo
			if _s.SuH_SETallowfemalehomo > 0
				_s.SuH_SETallowfemalehomo = 0
				SetToggleOptionValue(id16, FALSE) ;status.femalehomo
			else
				_s.SuH_SETallowfemalehomo = 1
				SetToggleOptionValue(id16, TRUE) ;status.femalehomo
			endIf
			
		elseif(option == id17) ;status.restricact
			if _s.SuH_SETrestrictact > 0
				_s.SuH_SETrestrictact = 0
				SetToggleOptionValue(id17, FALSE) ;status.restricact
			else
				_s.SuH_SETrestrictact = 1
				SetToggleOptionValue(id17, TRUE) ;status.restricact
			endIf
			
		elseif(option == id19) ;status.petspells
			if playerref.HasSpell(_s.SuH_spell_petself)
				playerref.RemoveSpell(_s.SuH_spell_petself)
				playerref.RemoveSpell(_s.SuH_spell_pettarget)
				SetToggleOptionValue(id19, FALSE) ;status.petspells
			else
				playerref.AddSpell(_s.SuH_spell_petself)
				playerref.AddSpell(_s.SuH_spell_pettarget)
				SetToggleOptionValue(id19, TRUE) ;status.petspells
			endIf
			
		elseif(option == id20) ;status.removepet
			if _s.SuH_SETpetremoveondeath > 0
				_s.SuH_SETpetremoveondeath = 0
				SetToggleOptionValue(id20, FALSE) ;status.removepet
			else
				_s.SuH_SETpetremoveondeath = 1
				SetToggleOptionValue(id20, TRUE) ;status.removepet
			endIf
			
		elseif(option == id3) ;status.dismisspet
			if _s.SuH_SETpetnewsumdismiss > 0
				_s.SuH_SETpetnewsumdismiss = 0
				SetToggleOptionValue(id3, FALSE) ;status.dismisspet
			else
				_s.SuH_SETpetnewsumdismiss = 1
				SetToggleOptionValue(id3, TRUE) ;status.dismisspet
			endIf
			
		elseif(option == id9) ;status.petstayfollowing
			if _s.SuH_SETpetstayfollowing > 0
				_s.SuH_SETpetstayfollowing = 0
				SetToggleOptionValue(id9, FALSE) ;status.dismisspet
			else
				_s.SuH_SETpetstayfollowing = 1
				SetToggleOptionValue(id9, TRUE) ;status.dismisspet
			endIf
			
		elseif(option == id21) ;status.combatseduction
			if _s.SuH_SETcombatseduction > 0
				_s.SuH_SETcombatseduction = 0
				SetToggleOptionValue(id21, FALSE) ;status.combatseduction
			else
				_s.SuH_SETcombatseduction = 1
				SetToggleOptionValue(id21, TRUE) ;status.combatseduction
			endIf
			
		elseif(option == id30) ;status.dom
			if _s.SuH_SETspecialdeath > 0
				_s.PlayerBase.SetEssential(False)
				;playerref.SetNoBleedoutRecovery(True)
				_s.SuH_SETspecialdeath = 0
				SetToggleOptionValue(id30, FALSE) ;status.dom
			else
				_s.PlayerBase.SetEssential(True)
				_s.SuH_SETspecialdeath = 1
				SetToggleOptionValue(id30, TRUE) ;status.dom
			endIf
			
		elseif(option == id32) ;status.loseitems
			if _s.SuH_SETsdloseitems > 0
				_s.SuH_SETsdloseitems = 0
				SetToggleOptionValue(id32, FALSE) ;status.loseitems
			else
				_s.SuH_SETsdloseitems = 1
				SetToggleOptionValue(id32, TRUE) ;status.loseitems
			endIf
			
		elseif(option == id33) ;status.losegold
			if _s.SuH_SETsdlosegold > 0
				_s.SuH_SETsdlosegold = 0
				SetToggleOptionValue(id33, FALSE) ;status.losegold
			else
				_s.SuH_SETsdlosegold = 1
				SetToggleOptionValue(id33, TRUE) ;status.losegold
			endIf
			
		elseif(option == id34) ;status.losebloodchips
			if _s.SuH_SETsdlosebloodchips > 0
				_s.SuH_SETsdlosebloodchips = 0
				SetToggleOptionValue(id34, FALSE) ;status.losebloodchips
			else
				_s.SuH_SETsdlosebloodchips = 1
				SetToggleOptionValue(id34, TRUE) ;status.losebloodchips
			endIf
			
		elseif(option == id35) ;status.loseequip
			if _s.SuH_SETsdloseequip > 0
				_s.SuH_SETsdloseequip = 0
				SetToggleOptionValue(id35, FALSE) ;status.loseequip
			else
				_s.SuH_SETsdloseequip = 1
				SetToggleOptionValue(id35, TRUE) ;status.loseequip
			endIf
			
		elseif(option == id38) ;status.neverdie
			if _s.SuH_SETneverdiemode > 0
				_s.SuH_SETneverdiemode = 0
				SetToggleOptionValue(option, FALSE) ;status.neverdie
			else
				_s.SuH_SETneverdiemode = 1
				SetToggleOptionValue(option, TRUE) ;status.neverdie
			endIf
		elseif(option == id39) ;status.SuH_SETmilkdistribute
			if _s.SuH_SETmilkdistribute > 0
				_s.SuH_SETmilkdistribute = 0
				SetToggleOptionValue(option, FALSE) ;settings.SuH_SETmilkdistribute
			else
				_s.SuH_SETmilkdistribute = 1
				SetToggleOptionValue(option, TRUE) ;settings.SuH_SETmilkdistribute
			endIf
		elseif(option == id40) ;status.SuH_SETdynaspid
			if _s.SuH_SETdynaspid > 0
				_s.SuH_SETdynaspid = 0
				SetToggleOptionValue(option, FALSE) ;settings.SuH_SETmilkdistribute
			else
				_s.SuH_SETdynaspid = 1
				SetToggleOptionValue(option, TRUE) ;settings.SuH_SETmilkdistribute
			endIf
		elseif(option == id41) ;status.SuH_SETspermdistribute
			if _s.SuH_SETspermdistribute > 0
				_s.SuH_SETspermdistribute = 0
				SetToggleOptionValue(option, FALSE) ;settings.SuH_SETmilkdistribute
			else
				_s.SuH_SETspermdistribute = 1
				SetToggleOptionValue(option, TRUE) ;settings.SuH_SETmilkdistribute
			endIf
		elseif(option == id11) ;_s.SuH_SETtraitwontkill
			if _s.SuH_SETtraitwontkill > 0
				_s.SuH_SETtraitwontkill = 0
				SetToggleOptionValue(option, FALSE) ;SuH_SETtraitwontkill
			else
				_s.SuH_SETtraitwontkill = 1
				SetToggleOptionValue(option, TRUE) ;SuH_SETtraitwontkill
			endIf
		elseif(option == id42) ;_s.SuH_SETdrainvisualinact
			if _s.SuH_SETdrainvisualinact > 0
				_s.SuH_SETdrainvisualinact = 0
				SetToggleOptionValue(option, FALSE) ;SuH_SETdrainvisualinact
			else
				_s.SuH_SETdrainvisualinact = 1
				SetToggleOptionValue(option, TRUE) ;SuH_SETdrainvisualinact
			endIf
		elseif(option == id44) ;_s.SuH_SETpreventactdeath
			if _s.SuH_SETpreventactdeath > 0
				_s.SuH_SETpreventactdeath = 0
				SetToggleOptionValue(option, FALSE) ;SuH_SETpreventactdeath
			else
				_s.SuH_SETpreventactdeath = 1
				SetToggleOptionValue(option, TRUE) ;SuH_SETpreventactdeath
			endIf
		elseif option == id48
			if _s.SuH_SETpheromessage > 0
				_s.SuH_SETpheromessage = 0
				SetToggleOptionValue(option, false)
			else
				_s.SuH_SETpheromessage = 1
				SetToggleOptionValue(option, true)
			endif
		elseif option == id49
			if _s.SuH_CSConfirmMessage > 0
				_s.SuH_CSConfirmMessage = 0
				SetToggleOptionValue(option, false)
			else
				_s.SuH_CSConfirmMessage = 1
				SetToggleOptionValue(option, true)
			endif
		endIf
	endevent

	event OnOptionDefault(int option)
		if option == id48
			_s.SuH_SETpheromessage = 1
			SetToggleOptionValue(option, true)
		elseif option == id49
			_s.SuH_CSConfirmMessage = 1
			SetToggleOptionValue(option, true)
		endif
	endevent

	event OnOptionHighlight(int option)
		If(option == id0)
			SetInfoText("$SUH_SET_HEARTXPMULTI")
		elseIf(option == id1)
			SetInfoText("$SUH_SET_DRAINAFFECTNPCSTATUS")
		elseIf(option == id2)
			SetInfoText("$SUH_SET_DRAINALWAYSBENEFITS")
		elseif(option == id3)
			SetInfoText("$SUH_SET_DISMISSWHENSUMMON")
		elseif(option == id4)
			SetInfoText("$SUH_SET_ALLOWDRAINKILL")
		elseIf(option == id5)
			SetInfoText("$SUH_SET_DRAINALWAYSKILLS")
		elseIf(option == id6)
			SetInfoText("$SUH_SET_DRAINRESETORGASM")
		elseIf(option == id7)
			SetInfoText("$SUH_SET_CALMENEMIESDURINGSEX")
		elseif(option == id8)
			SetInfoText("$SUH_SET_ALLOWDEATHDROPS")
		elseif(option == id9)
			SetInfoText("$SUH_SET_PETDONTUNFOLLOW")
		elseIf(option == id10)
			SetInfoText("$SUH_SET_LUSTMULTI")
		elseif(option == id11)
			SetInfoText("$SUH_SET_PETACTTRAITWONTKILL")
		elseif(option == id12)
			SetInfoText("$SUH_SET_HOSTILEVIGIL")
		elseIf(option == id13)
			SetInfoText("$SUH_SET_ENDSEXWHENATTACKED")
		elseIf(option == id14)
			SetInfoText("$SUH_SET_CLEANARROWS")
		elseif(option == id15)
			SetInfoText("$SUH_SET_ALLOWMALEHOMO")
		elseif(option == id16)
			SetInfoText("$SUH_SET_ALOWFEMALEHOMO")
		elseIf(option == id17)
			SetInfoText("$SUH_SET_FORCECOWGIRL")
		elseIf(option == id18)
			SetInfoText("$SUH_SET_LUSTDEFECTS")
		elseif(option == id19)
			SetInfoText("$SUH_SET_DISPLAYPETSPELLS")
		elseif(option == id20)
			SetInfoText("$SUH_SET_REMOVEPETSONDEATH")
		elseif(option == id21)
			SetInfoText("$SUH_SET_ENABLECOMBATSEDUCTION")
		elseif(option == id22)
			SetInfoText("$SUH_SET_COMBATSUBMITCOOLDOWN")
		elseif(option == id23)
			SetInfoText("$SUH_SET_COMBATSUBMITPLAYERUNDERHPPERC")
		elseif(option == id24)
			SetInfoText("$SUH_SET_COMBATSUBMITPLAYERUNDERHP")
		elseif(option == id25)
			SetInfoText("$SUH_SET_COMBATSUBMITPLAYERUNDERSPPERC")
		elseif(option == id26)
			SetInfoText("$SUH_SET_COMBATSUBMITNPCTOPCHPPERC")
		elseif(option == id27)
			SetInfoText("$SUH_SET_COMBATSUBMITNPCTOPCHP")
		elseif(option == id28)
			SetInfoText("$SUH_SET_COMBATSUBMITNPCTONPCHPPERC")
		elseif(option == id29)
			SetInfoText("$SUH_SET_COMBATSUBMITNPCTONPCHP")
		elseIf(option == id30)
			SetInfoText("$SUH_SET_DOMENABLE")
		elseIf(option == id31)
			SetInfoText("$SUH_SET_DOMFORCERESPAWNLOC")
		elseIf(option == id32)
			SetInfoText("$SUH_SET_DOMLOSEITEMSONDEATH")
		elseIf(option == id33)
			SetInfoText("$SUH_SET_DOMLOSEGOLDONDEATH")
		elseIf(option == id34)
			SetInfoText("$SUH_SET_DOMLOSEBLOODCHIPSONDEATH")
		elseIf(option == id35)
			SetInfoText("$SUH_SET_DOMDESTROYEQUIPONDEATH")
		elseIf(option == id36)
			SetInfoText("$SUH_SET_DOMREVIVALCOST")
		elseif(option == id37)
			SetInfoText("$SUH_SET_DOMBLEEDOUTDELAY")
		elseIf(option == id38)
			SetInfoText("$SUH_SET_DOMNEVERDIEMODE")
		elseIf(option == id39)
			SetInfoText("$SUH_SET_FEMALEGIVEMILK")
		elseIf(option == id40)
			SetInfoText("$SUH_SET_USESPID")
		elseIf(option == id41)
			SetInfoText("$SUH_SET_MALESGIVESPERM")
		elseIf(option == id42)
			SetInfoText("$SUH_SET_DRAINVISUALSINACT")
		elseif(option == id43)
			SetInfoText("$SUH_SET_ATTEMPTSLAIFIX")
		elseIf(option == id44)
			SetInfoText("$SUH_SET_PREVENTDEATHINACT")
		elseIf(option == id45)
			SetInfoText("$SUH_SET_REALMSPELLCOSTMAGICKA")
		elseIf(option == id46)
			SetInfoText("$SUH_SET_ONLYUSEPREFFRAMEWORK")
		elseif(option == id47)
			SetInfoText("$SUH_SET_ALLOWCONTROLOVERRIDE")
		elseif option == id48
			SetInfoText("$SUH_SETTINGS_PHEROMESSAGE")
		elseif option == id49
			SetInfoText("$SUH_SETTINGS_CSDISPLAYMESSAGE")
		else
			AllOptionHighlightCheck(option)
		endif
	endevent

endstate

state PAGE_HELP

	function SetUpPage()
		if seen_help != true
			debug.MessageBox("< Help > \n  This MCM menu stores general information and help articles. If you're having issues understanding mechanics or want to check what various terms refer to, check here! If you don't find help here you can still join the Discord channel for further assistance!")
			seen_help = true
		endIf
		SetCursorFillMode(TOP_TO_BOTTOM) ;36+?
		
		;	Left Side
		SetCursorPosition(0)
		id0 = AddTextOption("TBC Discord for Updates and Support","> > >")
		AddHeaderOption("$SUH_Key Terms / Vocabulary")
		id2 = AddTextOption("$SUH_Status", " ")
		id3 = AddTextOption("$SUH_Max Status", " ")
		id4 = AddTextOption("$SUH_Status Cap", " ")
		id5 = AddTextOption("$SUH_HeartXP", " ")
		id6 = AddTextOption("$SUH_SkillXP", " ")
		id7 = AddTextOption("$SUH_Sex Bonus (Time)", " ")
		id8 = AddTextOption("$SUH_Fluid Bonus (Time)", " ")
		id9 = AddTextOption("$SUH_Sex Act", " ") ; SexAct
		AddHeaderOption("$SUH_Menu Descriptions")
		id10 = AddTextOption("$SUH_Status", " ") ; Status
		id11 = AddTextOption("$SUH_Heart Levels", " ") ; Heart Levels
		id12 = AddTextOption("$SUH_Skill Levels", " ") ; Skill Levels
		id13 = AddTextOption("$SUH_Passives", " ") ; Passives
		id14 = AddTextOption("$SUH_Actives", " ") ; Actives
		id15 = AddTextOption("$SUH_Soul Pets", " ") ; Soul Pets
		id16 = AddTextOption("$SUH_Titles", " ") ; Titles
		id17 = AddTextOption("$SUH_Help", " ") ; Help
			
		;	Right Side
		SetCursorPosition(1)
		id1 = AddTextOption("https://discord.gg/h3vB7S4FEw", "") ; https://discord.gg/h3vB7S4FEw
		AddHeaderOption("$SUH_The Basics")
		id18 = AddTextOption("$SUH_Drain and it's Effects", " ") ;help.drain
		id19 = AddTextOption("$SUH_Lust and Withdrawl", " ") ;help.arousal
		id20 = AddTextOption("$SUH_Earning and Spending HeartXP", " ") ;help.xp
		id21 = AddTextOption("$SUH_Earning and Spending SkillXP", " ") ;help.sp
		id22 = AddTextOption("$SUH_Sex/Death Drops", " ") ;help.drops
		id23 = AddTextOption("$SUH_BDSM Rating and Abilities", " ") ;help.bdsm
		id24 = AddTextOption("$SUH_Unlocking Titles", " ") ;help.titles
		AddHeaderOption("$SUH_Optional Mechanics")
		id25 = AddTextOption("$SUH_The Succubus Realm", " ") ;help.realm
		id26 = AddTextOption("$SUH_Offering System", " ") ;offeringsystem
		id27 = AddTextOption("$SUH_Fluid Fountain", " ") ;fluidfountain
		id28 = AddTextOption("$SUH_Tali's Worktable", " ") ;talitable
		id29 = AddTextOption("$SUH_Soul Pets", " ") ;help.pets
		id30 = AddTextOption("$SUH_Combat Seduction", " ") ;help.cs
		id31 = AddTextOption("$SUH_Death Override Mode", " ") ;help.dom
		AddHeaderOption("$SUH_Random Notes")
		id32 = AddTextOption("$SUH_Woops...", " ") ;help.hungrychest
		id33 = AddTextOption("$SUH_He's always there for me <3", " ") ;help.petuse
		id34 = AddTextOption("$SUH_Sweet dreams are sweeter with me", " ") ;help.seduction
		id35 = AddTextOption("$SUH_I had too many to use", " ") ;help.offering
	endfunction

	event OnOptionHighlight(int option)
		if option == id0 || option == id1
			SetInfoText("Join The Broken Chatbox Discord! Here you can get updates, assistance, or just hang out! [https://discord.gg/h3vB7S4FEw]")
		elseif option == id2
			SetInfoText("$SUH_HELP_STATUS")
		elseif option == id3
			SetInfoText("$SUH_HELP_MAXSTATUS")
		elseif option == id4
			SetInfoText("$SUH_HELP_STATUSCAP")
		elseif option == id5
			SetInfoText("$SUH_HELP_HEARTXP")
		elseif option == id6
			SetInfoText("$SUH_HELP_SKILLXP")
		elseif option == id7
			SetInfoText("$SUH_HELP_SEXBONUSTIME")
		elseif option == id8
			SetInfoText("$SUH_HELP_FLUIDBONUSTIME")
		elseif option == id9
			SetInfoText("$SUH_HELP_SEXACT")
		elseif option == id10
			SetInfoText("$SUH_HELP_MENUSTATUS")
		elseif option == id11
			SetInfoText("$SUH_HELP_MENUHEARTLEVELS")
		elseif option == id12
			SetInfoText("$SUH_HELP_MENUSKILLLEVELS")
		elseif option == id13
			SetInfoText("$SUH_HELP_MENUPASSIVES")
		elseif option == id14
			SetInfoText("$SUH_HELP_MENUACTIVES")
		elseif option == id15
			SetInfoText("$SUH_HELP_MENUSOULPETS")
		elseif option == id16
			SetInfoText("$SUH_HELP_MENUTITLES")
		elseif option == id17
			SetInfoText("$SUH_HELP_MENUHELP")
		elseif option == id18
			SetInfoText("$SUH_HELP_DRAINEFFECTS")
		elseif option == id19
			SetInfoText("$SUH_HELP_LUSTWITHDRAWL")
		elseif option == id20
			SetInfoText("$SUH_HELP_EARNINGHEARTXP")
		elseif option == id21
			SetInfoText("$SUH_HELP_EARNINGSKILLXP")
		elseif option == id22
			SetInfoText("$SUH_HELP_SEXDEATHDROPS")
		elseif option == id23
			SetInfoText("$SUH_HELP_BDSMRATING")
		elseif option == id24
			SetInfoText("$SUH_HELP_UNLOCKINGTITLES")
		elseif option == id25
			SetInfoText("$SUH_HELP_SUCCUBUSREALM")
		elseif option == id26
			SetInfoText("$SUH_HELP_OFFERINGSYSTEM")
		elseif option == id27
			SetInfoText("$SUH_HELP_FLUIDFOUNTAIN")
		elseif option == id28
			SetInfoText("$SUH_HELP_TALIWORKSHOP")
		elseif option == id29
			SetInfoText("$SUH_HELP_SOULPETS")
		elseif option == id30
			SetInfoText("$SUH_HELP_COMBATSEDUCTION")
		elseif option == id31
			SetInfoText("$SUH_HELP_DEATHOVERRIDEMODE")
		elseif option == id32
			SetInfoText("$SUH_HELP_HUNGRYCHEST")
		elseif option == id33
			SetInfoText("$SUH_HELP_PETUSE")
		elseif option == id34
			SetInfoText("$SUH_HELP_NOTESEDUCTION")
		elseif option == id35
			SetInfoText("$SUH_HELP_NOTECOMBINE")
		else
			AllOptionHighlightCheck(option)
		endif
	endevent

endstate
